/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.common.logging.utils;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class RegexUtil {
    public static Map<String, Collection<String>> removeByKeyRegexPatterns(Map<String, Collection<String>> targetMap, List<Pattern> patterns) {
        return targetMap.entrySet().stream().filter(entry -> RegexUtil.matchKey((String)entry.getKey(), patterns)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Collection<String> removeByRegexPatterns(Collection<String> targetCollection, List<Pattern> patterns) {
        return targetCollection.stream().filter(key -> RegexUtil.matchKey(key, patterns)).collect(Collectors.toList());
    }

    public static boolean matchKey(String string, List<Pattern> patterns) {
        return patterns.stream().noneMatch(s -> RegexUtil.matchKey(string, s));
    }

    private static boolean matchKey(String string, Pattern pattern) {
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    private RegexUtil() {
    }
}

