/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracing;
import brave.internal.Nullable;
import brave.jms.JmsTracing;
import brave.jms.MessageConsumerRequest;
import brave.messaging.MessagingRequest;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.sampler.SamplerFunction;
import javax.jms.Destination;
import javax.jms.Message;

abstract class TracingConsumer<C> {
    final C delegate;
    final JmsTracing jmsTracing;
    final Tracing tracing;
    final TraceContext.Extractor<MessageConsumerRequest> extractor;
    final TraceContext.Injector<MessageConsumerRequest> injector;
    final SamplerFunction<MessagingRequest> sampler;
    @Nullable
    final String remoteServiceName;

    TracingConsumer(C delegate, JmsTracing jmsTracing) {
        this.delegate = delegate;
        this.jmsTracing = jmsTracing;
        this.tracing = jmsTracing.tracing;
        this.extractor = jmsTracing.messageConsumerExtractor;
        this.sampler = jmsTracing.consumerSampler;
        this.injector = jmsTracing.messageConsumerInjector;
        this.remoteServiceName = jmsTracing.remoteServiceName;
    }

    void handleReceive(Message message) {
        TraceContextOrSamplingFlags extracted;
        if (message == null || this.tracing.isNoop()) {
            return;
        }
        MessageConsumerRequest request = new MessageConsumerRequest(message, this.destination(message));
        Span span = this.jmsTracing.nextMessagingSpan(this.sampler, (MessagingRequest)request, extracted = this.jmsTracing.extractAndClearTraceIdProperties(this.extractor, request, message));
        if (!span.isNoop()) {
            span.name("receive").kind(Span.Kind.CONSUMER);
            Destination destination = this.destination(message);
            if (destination != null) {
                this.jmsTracing.tagQueueOrTopic((MessagingRequest)request, (SpanCustomizer)span);
            }
            if (this.remoteServiceName != null) {
                span.remoteServiceName(this.remoteServiceName);
            }
            long timestamp = this.tracing.clock(span.context()).currentTimeMicroseconds();
            span.start(timestamp).finish(timestamp);
        }
        this.injector.inject(span.context(), (Object)request);
    }

    @Nullable
    abstract Destination destination(Message var1);
}

