/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.validation;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xmlunit.ConfigurationException;
import org.xmlunit.XMLUnitException;
import org.xmlunit.util.Convert;
import org.xmlunit.validation.ValidationHandler;
import org.xmlunit.validation.ValidationResult;
import org.xmlunit.validation.Validator;

public class ParsingValidator
extends Validator {
    private final String language;
    private String schemaURI;

    public ParsingValidator(String language) {
        if (!"http://www.w3.org/2001/XMLSchema".equals(language) && !"http://www.w3.org/TR/REC-xml".equals(language)) {
            throw new IllegalArgumentException("only DTD and W3C Schema validation are supported by ParsingValidator");
        }
        this.language = language;
    }

    public void setSchemaURI(String uri) {
        this.schemaURI = uri;
    }

    protected String getSchemaURI() {
        return this.schemaURI;
    }

    @Override
    public ValidationResult validateSchema() {
        throw new XMLUnitException("Schema validation is not supported by ParsingValidator");
    }

    @Override
    public ValidationResult validateInstance(Source s) {
        return this.validateInstance(s, SAXParserFactory.newInstance());
    }

    public ValidationResult validateInstance(Source s, SAXParserFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        try {
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            SAXParser parser = factory.newSAXParser();
            if ("http://www.w3.org/2001/XMLSchema".equals(this.language)) {
                parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            }
            Source[] source = this.getSchemaSources();
            Handler handler = new Handler();
            if (source.length != 0) {
                if ("http://www.w3.org/2001/XMLSchema".equals(this.language)) {
                    InputSource[] schemaSource = new InputSource[source.length];
                    for (int i = 0; i < source.length; ++i) {
                        schemaSource[i] = Convert.toInputSource(source[i]);
                    }
                    parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", schemaSource);
                } else if (source.length == 1) {
                    handler.setSchemaSystemId(source[0].getSystemId());
                }
            }
            InputSource input = Convert.toInputSource(s);
            try {
                parser.parse(input, (DefaultHandler)handler);
            }
            catch (SAXParseException e) {
                handler.error(e);
            }
            catch (SAXException e) {
                throw new XMLUnitException(e);
            }
            return handler.getResult();
        }
        catch (ParserConfigurationException ex) {
            throw new ConfigurationException(ex);
        }
        catch (SAXNotRecognizedException ex) {
            throw new ConfigurationException(ex);
        }
        catch (SAXNotSupportedException ex) {
            throw new ConfigurationException(ex);
        }
        catch (SAXException ex) {
            throw new XMLUnitException(ex);
        }
        catch (IOException ex) {
            throw new XMLUnitException(ex);
        }
    }

    private static class Properties {
        static final String SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
        static final String SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

        private Properties() {
        }
    }

    private class Handler
    extends DefaultHandler {
        private final ValidationHandler v = new ValidationHandler();
        private String systemId;

        private Handler() {
        }

        @Override
        public void error(SAXParseException e) {
            this.v.error(e);
        }

        @Override
        public void fatalError(SAXParseException e) {
            this.v.fatalError(e);
        }

        @Override
        public void warning(SAXParseException e) {
            this.v.warning(e);
        }

        private void setSchemaSystemId(String id) {
            this.systemId = id;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
            if (this.systemId != null && (ParsingValidator.this.getSchemaURI() == null || ParsingValidator.this.getSchemaURI().equals(publicId))) {
                return new InputSource(this.systemId);
            }
            return super.resolveEntity(publicId, systemId);
        }

        ValidationResult getResult() {
            return this.v.getResult();
        }
    }
}

