/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.threetenbp.deser.key;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.threetenbp.deser.key.ThreeTenKeyDeserializer;
import java.io.IOException;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.Year;

public class YearKeyDeserializer
extends ThreeTenKeyDeserializer {
    public static final YearKeyDeserializer INSTANCE = new YearKeyDeserializer();

    protected YearKeyDeserializer() {
    }

    protected Year deserialize(String key, DeserializationContext ctxt) throws IOException {
        try {
            return Year.of((int)Integer.parseInt(key));
        }
        catch (NumberFormatException nfe) {
            return (Year)this._handleDateTimeException(ctxt, Year.class, new DateTimeException("Number format exception", (Throwable)nfe), key);
        }
        catch (DateTimeException dte) {
            return (Year)this._handleDateTimeException(ctxt, Year.class, dte, key);
        }
    }
}

