/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.kubernetes;

import com.hazelcast.config.properties.PropertyDefinition;
import com.hazelcast.kubernetes.HazelcastKubernetesDiscoveryStrategy;
import com.hazelcast.kubernetes.KubernetesProperties;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.DiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryStrategyFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class HazelcastKubernetesDiscoveryStrategyFactory
implements DiscoveryStrategyFactory {
    private static final Collection<PropertyDefinition> PROPERTY_DEFINITIONS = Collections.unmodifiableCollection(Arrays.asList(KubernetesProperties.SERVICE_DNS, KubernetesProperties.SERVICE_DNS_TIMEOUT, KubernetesProperties.SERVICE_NAME, KubernetesProperties.SERVICE_LABEL_NAME, KubernetesProperties.SERVICE_LABEL_VALUE, KubernetesProperties.NAMESPACE, KubernetesProperties.POD_LABEL_NAME, KubernetesProperties.POD_LABEL_VALUE, KubernetesProperties.RESOLVE_NOT_READY_ADDRESSES, KubernetesProperties.USE_NODE_NAME_AS_EXTERNAL_ADDRESS, KubernetesProperties.KUBERNETES_API_RETIRES, KubernetesProperties.KUBERNETES_MASTER_URL, KubernetesProperties.KUBERNETES_API_TOKEN, KubernetesProperties.KUBERNETES_CA_CERTIFICATE, KubernetesProperties.SERVICE_PORT));

    @Override
    public Class<? extends DiscoveryStrategy> getDiscoveryStrategyType() {
        return HazelcastKubernetesDiscoveryStrategy.class;
    }

    @Override
    public DiscoveryStrategy newDiscoveryStrategy(DiscoveryNode discoveryNode, ILogger logger, Map<String, Comparable> properties) {
        return new HazelcastKubernetesDiscoveryStrategy(logger, properties);
    }

    @Override
    public Collection<PropertyDefinition> getConfigurationProperties() {
        return PROPERTY_DEFINITIONS;
    }

    @Override
    public boolean isAutoDetectionApplicable() {
        return this.tokenFileExists() && this.defaultKubernetesMasterReachable();
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    boolean tokenFileExists() {
        return new File("/var/run/secrets/kubernetes.io/serviceaccount/token").exists();
    }

    private boolean defaultKubernetesMasterReachable() {
        try {
            InetAddress.getByName("kubernetes.default.svc");
            return true;
        }
        catch (UnknownHostException e) {
            ILogger logger = Logger.getLogger(HazelcastKubernetesDiscoveryStrategyFactory.class);
            logger.warning("Hazelcast running on Kubernetes, but \"kubernetes.default.svc\" is not reachable. Check your Kubernetes DNS configuration.");
            logger.finest(e);
            return false;
        }
    }

    @Override
    public DiscoveryStrategyFactory.DiscoveryStrategyLevel discoveryStrategyLevel() {
        return DiscoveryStrategyFactory.DiscoveryStrategyLevel.PLATFORM;
    }
}

