/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.adapter.jdbc;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.adapter.jdbc.JdbcConvention;
import com.hazelcast.org.apache.calcite.adapter.jdbc.JdbcImplementor;
import com.hazelcast.org.apache.calcite.adapter.jdbc.JdbcRel;
import com.hazelcast.org.apache.calcite.adapter.jdbc.JdbcTable;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.plan.RelTrait;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.TableScan;
import com.hazelcast.org.apache.calcite.rel.rel2sql.SqlImplementor;
import java.util.List;
import java.util.Objects;

public class JdbcTableScan
extends TableScan
implements JdbcRel {
    public final JdbcTable jdbcTable;

    protected JdbcTableScan(RelOptCluster cluster, RelOptTable table, JdbcTable jdbcTable, JdbcConvention jdbcConvention) {
        super(cluster, cluster.traitSetOf((RelTrait)jdbcConvention), ImmutableList.of(), table);
        this.jdbcTable = Objects.requireNonNull(jdbcTable);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return new JdbcTableScan(this.getCluster(), this.table, this.jdbcTable, (JdbcConvention)this.getConvention());
    }

    @Override
    public SqlImplementor.Result implement(JdbcImplementor implementor) {
        return implementor.result(this.jdbcTable.tableName(), ImmutableList.of(SqlImplementor.Clause.FROM), this, null);
    }
}

