/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.com.google.common.collect.ImmutableMap;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.util.NlsString;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SqlHint
extends SqlCall {
    private final SqlIdentifier name;
    private final SqlNodeList options;
    private final HintOptionFormat optionFormat;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("HINT", SqlKind.HINT);

    public SqlHint(SqlParserPos pos, SqlIdentifier name, SqlNodeList options, HintOptionFormat optionFormat) {
        super(pos);
        this.name = name;
        this.optionFormat = optionFormat;
        this.options = options;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableList.of(this.name, this.options);
    }

    public String getName() {
        return this.name.getSimple();
    }

    public HintOptionFormat getOptionFormat() {
        return this.optionFormat;
    }

    public List<String> getOptionList() {
        if (this.optionFormat == HintOptionFormat.ID_LIST) {
            List attrs = this.options.getList().stream().map(node -> ((SqlIdentifier)node).getSimple()).collect(Collectors.toList());
            return ImmutableList.copyOf(attrs);
        }
        if (this.optionFormat == HintOptionFormat.LITERAL_LIST) {
            List attrs = this.options.getList().stream().map(node -> {
                SqlLiteral literal = (SqlLiteral)node;
                Comparable comparable = SqlLiteral.value(literal);
                return comparable instanceof NlsString ? ((NlsString)comparable).getValue() : comparable.toString();
            }).collect(Collectors.toList());
            return ImmutableList.copyOf(attrs);
        }
        return ImmutableList.of();
    }

    public Map<String, String> getOptionKVPairs() {
        if (this.optionFormat == HintOptionFormat.KV_LIST) {
            HashMap<String, String> attrs = new HashMap<String, String>();
            for (int i = 0; i < this.options.size() - 1; i += 2) {
                SqlNode k = this.options.get(i);
                SqlNode v = this.options.get(i + 1);
                attrs.put(SqlHint.getOptionKeyAsString(k), ((SqlLiteral)v).getValueAs(String.class));
            }
            return ImmutableMap.copyOf(attrs);
        }
        return ImmutableMap.of();
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.options.size() > 0) {
            SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.FUN_CALL, "(", ")");
            for (int i = 0; i < this.options.size(); ++i) {
                SqlNode option = this.options.get(i);
                SqlNode nextOption = i < this.options.size() - 1 ? this.options.get(i + 1) : null;
                writer.sep(",", false);
                option.unparse(writer, leftPrec, rightPrec);
                if (this.optionFormat != HintOptionFormat.KV_LIST || nextOption == null) continue;
                writer.keyword("=");
                nextOption.unparse(writer, leftPrec, rightPrec);
                ++i;
            }
            writer.endList(frame);
        }
    }

    private static String getOptionKeyAsString(SqlNode node) {
        assert (node instanceof SqlIdentifier || SqlUtil.isLiteral(node));
        if (node instanceof SqlIdentifier) {
            return ((SqlIdentifier)node).getSimple();
        }
        return ((SqlLiteral)node).getValueAs(String.class);
    }

    public static enum HintOptionFormat {
        EMPTY,
        LITERAL_LIST,
        ID_LIST,
        KV_LIST;

    }
}

