/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite;

import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.JetSqlCoreBackend;
import com.hazelcast.sql.impl.calcite.HazelcastSqlBackend;
import com.hazelcast.sql.impl.calcite.OptimizerContext;
import com.hazelcast.sql.impl.calcite.SqlBackend;
import com.hazelcast.sql.impl.calcite.parse.QueryParseResult;
import com.hazelcast.sql.impl.optimizer.OptimizationTask;
import com.hazelcast.sql.impl.optimizer.SqlOptimizer;
import com.hazelcast.sql.impl.optimizer.SqlPlan;
import javax.annotation.Nullable;

public class CalciteSqlOptimizer
implements SqlOptimizer {
    private final NodeEngine nodeEngine;
    private final SqlBackend sqlBackend;
    private final SqlBackend jetSqlBackend;

    public CalciteSqlOptimizer(NodeEngine nodeEngine, @Nullable JetSqlCoreBackend jetSqlCoreBackend) {
        this.nodeEngine = nodeEngine;
        this.sqlBackend = new HazelcastSqlBackend(nodeEngine);
        this.jetSqlBackend = jetSqlCoreBackend == null ? null : (SqlBackend)jetSqlCoreBackend.sqlBackend();
    }

    @Override
    public SqlPlan prepare(OptimizationTask task) {
        int memberCount = this.nodeEngine.getClusterService().getSize(MemberSelectors.DATA_MEMBER_SELECTOR);
        OptimizerContext context = OptimizerContext.create(task.getSchema(), task.getSearchPaths(), memberCount, this.sqlBackend, this.jetSqlBackend);
        QueryParseResult parseResult = context.parse(task.getSql());
        return parseResult.getSqlBackend().createPlan(task, parseResult, context);
    }
}

