/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.opt.physical;

import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelCollation;
import com.hazelcast.org.apache.calcite.rel.RelCollationTraitDef;
import com.hazelcast.org.apache.calcite.rel.RelCollations;
import com.hazelcast.org.apache.calcite.rel.RelFieldCollation;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.sql.impl.calcite.opt.HazelcastConventions;
import com.hazelcast.sql.impl.calcite.opt.OptUtils;
import com.hazelcast.sql.impl.calcite.opt.distribution.DistributionTrait;
import com.hazelcast.sql.impl.calcite.opt.distribution.DistributionType;
import com.hazelcast.sql.impl.calcite.opt.logical.ProjectLogicalRel;
import com.hazelcast.sql.impl.calcite.opt.physical.ProjectPhysicalRel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class ProjectPhysicalRule
extends RelOptRule {
    public static final RelOptRule INSTANCE = new ProjectPhysicalRule();

    private ProjectPhysicalRule() {
        super(OptUtils.parentChild(ProjectLogicalRel.class, RelNode.class, HazelcastConventions.LOGICAL), ProjectPhysicalRule.class.getSimpleName());
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        ProjectLogicalRel logicalProject = (ProjectLogicalRel)call.rel(0);
        RelNode input = logicalProject.getInput();
        Collection<InputAndTraitSet> transforms = ProjectPhysicalRule.getTransforms(logicalProject.getProjects(), input);
        for (InputAndTraitSet transform : transforms) {
            ProjectPhysicalRel newProject = new ProjectPhysicalRel(logicalProject.getCluster(), transform.getTraitSet(), transform.getInput(), logicalProject.getProjects(), logicalProject.getRowType());
            call.transformTo(newProject);
        }
    }

    private static Collection<InputAndTraitSet> getTransforms(List<RexNode> projects, RelNode input) {
        ArrayList<InputAndTraitSet> res = new ArrayList<InputAndTraitSet>(1);
        Collection<RelNode> physicalInputs = OptUtils.getPhysicalRelsFromSubset(input);
        HashMap<Integer, Integer> inputFieldIndex2ProjectIndexMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < projects.size(); ++i) {
            RexNode projectExp = projects.get(i);
            if (!(projectExp instanceof RexInputRef)) continue;
            inputFieldIndex2ProjectIndexMap.put(((RexInputRef)projectExp).getIndex(), i);
        }
        for (RelNode physicalInput : physicalInputs) {
            RelTraitSet traitSet = ProjectPhysicalRule.createPhysicalTraitSet(physicalInput);
            RelCollation transformedCollation = ProjectPhysicalRule.convertCollation(inputFieldIndex2ProjectIndexMap, traitSet.getTrait(RelCollationTraitDef.INSTANCE));
            RelTraitSet finalTraitSet = OptUtils.traitPlus(traitSet, transformedCollation);
            res.add(new InputAndTraitSet(physicalInput, finalTraitSet));
        }
        return res;
    }

    private static RelCollation convertCollation(Map<Integer, Integer> inputFieldIndex2ProjectIndex, RelCollation collation) {
        RelFieldCollation fieldCollation;
        int fieldIndex;
        Integer projectFiledIndex;
        ArrayList<RelFieldCollation> transformedFields = new ArrayList<RelFieldCollation>(collation.getFieldCollations().size());
        Iterator<RelFieldCollation> iterator = collation.getFieldCollations().iterator();
        while (iterator.hasNext() && (projectFiledIndex = inputFieldIndex2ProjectIndex.get(fieldIndex = (fieldCollation = iterator.next()).getFieldIndex())) != null) {
            RelFieldCollation transformedFieldCollation = new RelFieldCollation(projectFiledIndex, fieldCollation.getDirection());
            transformedFields.add(transformedFieldCollation);
        }
        return RelCollations.of(transformedFields);
    }

    private static RelTraitSet createPhysicalTraitSet(RelNode physicalInput) {
        return OptUtils.traitPlus(physicalInput.getTraitSet(), ProjectPhysicalRule.deriveDistribution(physicalInput));
    }

    private static DistributionTrait deriveDistribution(RelNode physicalInput) {
        DistributionTrait physicalInputDist = OptUtils.getDistribution(physicalInput);
        DistributionType type = physicalInputDist.getType();
        switch (type) {
            case ROOT: {
                return physicalInputDist;
            }
            case REPLICATED: {
                return physicalInputDist;
            }
        }
        assert (type == DistributionType.PARTITIONED);
        return physicalInputDist;
    }

    private static final class InputAndTraitSet {
        private final RelNode input;
        private final RelTraitSet traitSet;

        private InputAndTraitSet(RelNode input, RelTraitSet traitSet) {
            this.input = input;
            this.traitSet = traitSet;
        }

        public RelNode getInput() {
            return this.input;
        }

        public RelTraitSet getTraitSet() {
            return this.traitSet;
        }
    }
}

