/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec;

import com.hazelcast.sql.impl.exec.Exec;
import com.hazelcast.sql.impl.exec.IterationResult;
import com.hazelcast.sql.impl.row.EmptyRowBatch;
import com.hazelcast.sql.impl.row.RowBatch;
import com.hazelcast.sql.impl.worker.QueryFragmentContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public abstract class AbstractExec
implements Exec {
    protected QueryFragmentContext ctx;
    private final int id;
    private boolean done;

    protected AbstractExec(int id) {
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public final void setup(QueryFragmentContext ctx) {
        this.ctx = ctx;
        this.setup0(ctx);
    }

    @Override
    public final IterationResult advance() {
        this.checkCancelled();
        if (this.done) {
            throw new IllegalStateException("Iteration is finished.");
        }
        IterationResult res = this.advance0();
        if (res == IterationResult.FETCHED_DONE) {
            this.done = true;
        }
        return res;
    }

    @Override
    public final RowBatch currentBatch() {
        RowBatch res = this.currentBatch0();
        return res != null ? res : EmptyRowBatch.INSTANCE;
    }

    protected void setup0(QueryFragmentContext ctx) {
    }

    protected abstract IterationResult advance0();

    protected abstract RowBatch currentBatch0();

    protected void checkCancelled() {
        this.ctx.checkCancelled();
    }
}

