/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.plan.node;

import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.plan.node.AbstractPlanNode;
import com.hazelcast.sql.impl.plan.node.PlanNodeSchema;
import com.hazelcast.sql.impl.plan.node.PlanNodeVisitor;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.util.List;

public class EmptyPlanNode
extends AbstractPlanNode
implements IdentifiedDataSerializable {
    private List<QueryDataType> fieldTypes;

    public EmptyPlanNode() {
    }

    public EmptyPlanNode(int id, List<QueryDataType> fieldTypes) {
        super(id);
        this.fieldTypes = fieldTypes;
    }

    @Override
    protected PlanNodeSchema getSchema0() {
        return new PlanNodeSchema(this.fieldTypes);
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 47;
    }

    @Override
    protected void writeData0(ObjectDataOutput out) throws IOException {
        SerializationUtil.writeList(this.fieldTypes, out);
    }

    @Override
    protected void readData0(ObjectDataInput in) throws IOException {
        this.fieldTypes = SerializationUtil.readList(in);
    }

    @Override
    public void visit(PlanNodeVisitor visitor) {
        visitor.onEmptyNode(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmptyPlanNode planNode = (EmptyPlanNode)o;
        return this.id == planNode.id && this.fieldTypes.equals(planNode.fieldTypes);
    }

    public int hashCode() {
        return 31 * this.id + this.fieldTypes.hashCode();
    }
}

