/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.config.AbstractKafkaListenerEndpoint;
import org.springframework.kafka.config.ContainerCustomizer;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerEndpoint;
import org.springframework.kafka.config.KafkaListenerEndpointAdapter;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.kafka.listener.AfterRollbackProcessor;
import org.springframework.kafka.listener.BatchErrorHandler;
import org.springframework.kafka.listener.BatchInterceptor;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.ErrorHandler;
import org.springframework.kafka.listener.GenericErrorHandler;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.listener.RecordInterceptor;
import org.springframework.kafka.listener.adapter.BatchToRecordAdapter;
import org.springframework.kafka.listener.adapter.RecordFilterStrategy;
import org.springframework.kafka.listener.adapter.ReplyHeadersConfigurer;
import org.springframework.kafka.requestreply.ReplyingKafkaOperations;
import org.springframework.kafka.support.JavaUtils;
import org.springframework.kafka.support.TopicPartitionOffset;
import org.springframework.kafka.support.converter.BatchMessageConverter;
import org.springframework.kafka.support.converter.MessageConverter;
import org.springframework.kafka.support.converter.RecordMessageConverter;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public abstract class AbstractKafkaListenerContainerFactory<C extends AbstractMessageListenerContainer<K, V>, K, V>
implements KafkaListenerContainerFactory<C>,
ApplicationEventPublisherAware,
InitializingBean,
ApplicationContextAware {
    protected final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
    private final ContainerProperties containerProperties = new ContainerProperties((Pattern)null);
    private GenericErrorHandler<?> errorHandler;
    private CommonErrorHandler commonErrorHandler;
    private ConsumerFactory<? super K, ? super V> consumerFactory;
    private Boolean autoStartup;
    private Integer phase;
    private RecordMessageConverter recordMessageConverter;
    private BatchMessageConverter batchMessageConverter;
    private RecordFilterStrategy<? super K, ? super V> recordFilterStrategy;
    private Boolean ackDiscarded;
    private RetryTemplate retryTemplate;
    private RecoveryCallback<? extends Object> recoveryCallback;
    private Boolean statefulRetry;
    private Boolean batchListener;
    private ApplicationEventPublisher applicationEventPublisher;
    private KafkaTemplate<?, ?> replyTemplate;
    private AfterRollbackProcessor<? super K, ? super V> afterRollbackProcessor;
    private ReplyHeadersConfigurer replyHeadersConfigurer;
    private Boolean missingTopicsFatal;
    private RecordInterceptor<K, V> recordInterceptor;
    private BatchInterceptor<K, V> batchInterceptor;
    private BatchToRecordAdapter<K, V> batchToRecordAdapter;
    private ApplicationContext applicationContext;
    private ContainerCustomizer<K, V, C> containerCustomizer;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setConsumerFactory(ConsumerFactory<? super K, ? super V> consumerFactory) {
        this.consumerFactory = consumerFactory;
    }

    public ConsumerFactory<? super K, ? super V> getConsumerFactory() {
        return this.consumerFactory;
    }

    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    @Deprecated
    public void setMessageConverter(MessageConverter messageConverter) {
        if (messageConverter instanceof RecordMessageConverter) {
            this.setRecordMessageConverter((RecordMessageConverter)messageConverter);
        } else {
            this.setBatchMessageConverter((BatchMessageConverter)messageConverter);
        }
    }

    public void setRecordMessageConverter(RecordMessageConverter recordMessageConverter) {
        this.recordMessageConverter = recordMessageConverter;
    }

    public void setBatchMessageConverter(BatchMessageConverter batchMessageConverter) {
        this.batchMessageConverter = batchMessageConverter;
    }

    public void setRecordFilterStrategy(RecordFilterStrategy<? super K, ? super V> recordFilterStrategy) {
        this.recordFilterStrategy = recordFilterStrategy;
    }

    public void setAckDiscarded(Boolean ackDiscarded) {
        this.ackDiscarded = ackDiscarded;
    }

    @Deprecated
    public void setRetryTemplate(RetryTemplate retryTemplate) {
        this.retryTemplate = retryTemplate;
    }

    @Deprecated
    public void setRecoveryCallback(RecoveryCallback<? extends Object> recoveryCallback) {
        this.recoveryCallback = recoveryCallback;
    }

    @Deprecated
    public void setStatefulRetry(boolean statefulRetry) {
        this.statefulRetry = statefulRetry;
    }

    public Boolean isBatchListener() {
        return this.batchListener;
    }

    public void setBatchListener(Boolean batchListener) {
        this.batchListener = batchListener;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setReplyTemplate(KafkaTemplate<?, ?> replyTemplate) {
        if (replyTemplate instanceof ReplyingKafkaOperations) {
            this.logger.warn((CharSequence)"The 'replyTemplate' should not be an implementation of 'ReplyingKafkaOperations'; such implementations are for client-side request/reply operations; here we are simply sending a reply to an incoming request so the reply container will never be used and will consume unnecessary resources.");
        }
        this.replyTemplate = replyTemplate;
    }

    @Deprecated
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Deprecated
    public void setBatchErrorHandler(BatchErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setCommonErrorHandler(CommonErrorHandler commonErrorHandler) {
        this.commonErrorHandler = commonErrorHandler;
    }

    public void setAfterRollbackProcessor(AfterRollbackProcessor<? super K, ? super V> afterRollbackProcessor) {
        this.afterRollbackProcessor = afterRollbackProcessor;
    }

    public void setReplyHeadersConfigurer(ReplyHeadersConfigurer replyHeadersConfigurer) {
        this.replyHeadersConfigurer = replyHeadersConfigurer;
    }

    public void setMissingTopicsFatal(boolean missingTopicsFatal) {
        this.missingTopicsFatal = missingTopicsFatal;
    }

    public ContainerProperties getContainerProperties() {
        return this.containerProperties;
    }

    public void setRecordInterceptor(RecordInterceptor<K, V> recordInterceptor) {
        this.recordInterceptor = recordInterceptor;
    }

    public void setBatchInterceptor(BatchInterceptor<K, V> batchInterceptor) {
        this.batchInterceptor = batchInterceptor;
    }

    public void setBatchToRecordAdapter(BatchToRecordAdapter<K, V> batchToRecordAdapter) {
        this.batchToRecordAdapter = batchToRecordAdapter;
    }

    public void setContainerCustomizer(ContainerCustomizer<K, V, C> containerCustomizer) {
        this.containerCustomizer = containerCustomizer;
    }

    public void afterPropertiesSet() {
        if (this.commonErrorHandler == null && this.errorHandler != null) {
            if (Boolean.TRUE.equals(this.batchListener)) {
                Assert.state((boolean)(this.errorHandler instanceof BatchErrorHandler), () -> "The error handler must be a BatchErrorHandler, not " + this.errorHandler.getClass().getName());
            } else {
                Assert.state((boolean)(this.errorHandler instanceof ErrorHandler), () -> "The error handler must be an ErrorHandler, not " + this.errorHandler.getClass().getName());
            }
        }
    }

    @Override
    public C createListenerContainer(KafkaListenerEndpoint endpoint) {
        C instance = this.createContainerInstance(endpoint);
        JavaUtils.INSTANCE.acceptIfNotNull(endpoint.getId(), arg_0 -> instance.setBeanName(arg_0));
        if (endpoint instanceof AbstractKafkaListenerEndpoint) {
            this.configureEndpoint((AbstractKafkaListenerEndpoint)endpoint);
        }
        if (Boolean.TRUE.equals(endpoint.getBatchListener())) {
            endpoint.setupListenerContainer((MessageListenerContainer)instance, this.batchMessageConverter);
        } else {
            endpoint.setupListenerContainer((MessageListenerContainer)instance, this.recordMessageConverter);
        }
        this.initializeContainer(instance, endpoint);
        this.customizeContainer(instance);
        return instance;
    }

    private void configureEndpoint(AbstractKafkaListenerEndpoint<K, V> aklEndpoint) {
        if (aklEndpoint.getRecordFilterStrategy() == null) {
            JavaUtils.INSTANCE.acceptIfNotNull(this.recordFilterStrategy, aklEndpoint::setRecordFilterStrategy);
        }
        JavaUtils.INSTANCE.acceptIfNotNull(this.ackDiscarded, aklEndpoint::setAckDiscarded).acceptIfNotNull(this.retryTemplate, aklEndpoint::setRetryTemplate).acceptIfNotNull(this.recoveryCallback, aklEndpoint::setRecoveryCallback).acceptIfNotNull(this.statefulRetry, aklEndpoint::setStatefulRetry).acceptIfNotNull(this.replyTemplate, aklEndpoint::setReplyTemplate).acceptIfNotNull(this.replyHeadersConfigurer, aklEndpoint::setReplyHeadersConfigurer).acceptIfNotNull(this.batchToRecordAdapter, aklEndpoint::setBatchToRecordAdapter);
        if (aklEndpoint.getBatchListener() == null) {
            JavaUtils.INSTANCE.acceptIfNotNull(this.batchListener, aklEndpoint::setBatchListener);
        }
    }

    protected abstract C createContainerInstance(KafkaListenerEndpoint var1);

    protected void initializeContainer(C instance, KafkaListenerEndpoint endpoint) {
        ContainerProperties properties = ((AbstractMessageListenerContainer)instance).getContainerProperties();
        BeanUtils.copyProperties((Object)this.containerProperties, (Object)properties, (String[])new String[]{"topics", "topicPartitions", "topicPattern", "messageListener", "ackCount", "ackTime", "subBatchPerPartition", "kafkaConsumerProperties"});
        JavaUtils.INSTANCE.acceptIfNotNull(this.afterRollbackProcessor, arg_0 -> instance.setAfterRollbackProcessor(arg_0)).acceptIfCondition(this.containerProperties.getAckCount() > 0, this.containerProperties.getAckCount(), properties::setAckCount).acceptIfCondition(this.containerProperties.getAckTime() > 0L, this.containerProperties.getAckTime(), properties::setAckTime).acceptIfNotNull(this.containerProperties.getSubBatchPerPartition(), properties::setSubBatchPerPartition).acceptIfNotNull(this.errorHandler, arg_0 -> instance.setGenericErrorHandler(arg_0)).acceptIfNotNull(this.commonErrorHandler, arg_0 -> instance.setCommonErrorHandler(arg_0)).acceptIfNotNull(this.missingTopicsFatal, ((AbstractMessageListenerContainer)instance).getContainerProperties()::setMissingTopicsFatal);
        Boolean autoStart = endpoint.getAutoStartup();
        if (autoStart != null) {
            ((AbstractMessageListenerContainer)instance).setAutoStartup(autoStart);
        } else if (this.autoStartup != null) {
            ((AbstractMessageListenerContainer)instance).setAutoStartup(this.autoStartup);
        }
        ((AbstractMessageListenerContainer)instance).setRecordInterceptor(this.recordInterceptor);
        ((AbstractMessageListenerContainer)instance).setBatchInterceptor(this.batchInterceptor);
        JavaUtils.INSTANCE.acceptIfNotNull(this.phase, arg_0 -> instance.setPhase(arg_0)).acceptIfNotNull(this.applicationContext, arg_0 -> instance.setApplicationContext(arg_0)).acceptIfNotNull(this.applicationEventPublisher, arg_0 -> instance.setApplicationEventPublisher(arg_0)).acceptIfHasText(endpoint.getGroupId(), ((AbstractMessageListenerContainer)instance).getContainerProperties()::setGroupId).acceptIfHasText(endpoint.getClientIdPrefix(), ((AbstractMessageListenerContainer)instance).getContainerProperties()::setClientId).acceptIfNotNull(endpoint.getConsumerProperties(), ((AbstractMessageListenerContainer)instance).getContainerProperties()::setKafkaConsumerProperties).acceptIfNotNull(endpoint.getListenerInfo(), arg_0 -> instance.setListenerInfo(arg_0));
    }

    private void customizeContainer(C instance) {
        if (this.containerCustomizer != null) {
            this.containerCustomizer.configure(instance);
        }
    }

    @Override
    public C createContainer(final TopicPartitionOffset ... topicsAndPartitions) {
        KafkaListenerEndpointAdapter endpoint = new KafkaListenerEndpointAdapter(){

            @Override
            public TopicPartitionOffset[] getTopicPartitionsToAssign() {
                return Arrays.copyOf(topicsAndPartitions, topicsAndPartitions.length);
            }
        };
        C container = this.createContainerInstance(endpoint);
        this.initializeContainer(container, endpoint);
        this.customizeContainer(container);
        return container;
    }

    @Override
    public C createContainer(final String ... topics) {
        KafkaListenerEndpointAdapter endpoint = new KafkaListenerEndpointAdapter(){

            @Override
            public Collection<String> getTopics() {
                return Arrays.asList(topics);
            }
        };
        C container = this.createContainerInstance(endpoint);
        this.initializeContainer(container, endpoint);
        this.customizeContainer(container);
        return container;
    }

    @Override
    public C createContainer(final Pattern topicPattern) {
        KafkaListenerEndpointAdapter endpoint = new KafkaListenerEndpointAdapter(){

            @Override
            public Pattern getTopicPattern() {
                return topicPattern;
            }
        };
        C container = this.createContainerInstance(endpoint);
        this.initializeContainer(container, endpoint);
        this.customizeContainer(container);
        return container;
    }
}

