/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.springframework.kafka.listener.BatchErrorHandler;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.DeliveryAttemptAware;
import org.springframework.kafka.listener.ErrorHandler;
import org.springframework.kafka.listener.ExceptionClassifier;
import org.springframework.kafka.listener.FallbackBatchErrorHandler;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.listener.RemainingRecordsErrorHandler;
import org.springframework.kafka.support.TopicPartitionOffset;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class ErrorHandlerAdapter
extends ExceptionClassifier
implements CommonErrorHandler {
    private static final ConsumerRecords EMPTY_BATCH = new ConsumerRecords(Collections.emptyMap());
    private final ErrorHandler errorHandler;
    private final BatchErrorHandler batchErrorHandler;

    ErrorHandlerAdapter(ErrorHandler errorHandler) {
        Assert.notNull((Object)errorHandler, (String)"'errorHandler' cannot be null");
        this.errorHandler = errorHandler;
        this.batchErrorHandler = null;
    }

    ErrorHandlerAdapter(BatchErrorHandler batchErrorHandler) {
        Assert.notNull((Object)batchErrorHandler, (String)"'batchErrorHandler' cannot be null");
        this.errorHandler = null;
        this.batchErrorHandler = batchErrorHandler;
    }

    @Override
    public boolean remainingRecords() {
        return this.errorHandler instanceof RemainingRecordsErrorHandler;
    }

    @Override
    public boolean deliveryAttemptHeader() {
        return this.errorHandler instanceof DeliveryAttemptAware;
    }

    @Override
    public void clearThreadState() {
        if (this.errorHandler != null) {
            this.errorHandler.clearThreadState();
        } else {
            this.batchErrorHandler.clearThreadState();
        }
    }

    @Override
    public boolean isAckAfterHandle() {
        if (this.errorHandler != null) {
            return this.errorHandler.isAckAfterHandle();
        }
        return this.batchErrorHandler.isAckAfterHandle();
    }

    @Override
    public void setAckAfterHandle(boolean ack) {
        if (this.errorHandler != null) {
            this.errorHandler.setAckAfterHandle(ack);
        } else {
            this.batchErrorHandler.setAckAfterHandle(ack);
        }
    }

    @Override
    public int deliveryAttempt(TopicPartitionOffset topicPartitionOffset) {
        Assert.state((boolean)this.deliveryAttemptHeader(), (String)"This method should not be called by the container");
        return ((DeliveryAttemptAware)((Object)this.errorHandler)).deliveryAttempt(topicPartitionOffset);
    }

    @Override
    public void handleOtherException(Exception thrownException, Consumer<?, ?> consumer, MessageListenerContainer container, boolean batchListener) {
        if (this.errorHandler != null) {
            this.errorHandler.handle(thrownException, Collections.EMPTY_LIST, consumer, container);
        } else {
            this.batchErrorHandler.handle(thrownException, EMPTY_BATCH, consumer, container, () -> {});
        }
    }

    @Override
    public void handleRecord(Exception thrownException, ConsumerRecord<?, ?> record, Consumer<?, ?> consumer, MessageListenerContainer container) {
        if (this.errorHandler != null) {
            this.errorHandler.handle(thrownException, record, consumer);
        } else {
            CommonErrorHandler.super.handleRecord(thrownException, record, consumer, container);
        }
    }

    @Override
    public void handleRemaining(Exception thrownException, List<ConsumerRecord<?, ?>> records, Consumer<?, ?> consumer, MessageListenerContainer container) {
        if (this.errorHandler != null) {
            this.errorHandler.handle(thrownException, records, consumer, container);
        } else {
            CommonErrorHandler.super.handleRemaining(thrownException, records, consumer, container);
        }
    }

    @Override
    public void handleBatch(Exception thrownException, ConsumerRecords<?, ?> data, Consumer<?, ?> consumer, MessageListenerContainer container, Runnable invokeListener) {
        if (this.batchErrorHandler != null) {
            this.batchErrorHandler.handle(thrownException, data, consumer, container, invokeListener);
        } else {
            CommonErrorHandler.super.handleBatch(thrownException, data, consumer, container, invokeListener);
        }
    }

    @Override
    public void onPartitionsAssigned(Consumer<?, ?> consumer, Collection<TopicPartition> partitions, Runnable publishPause) {
        if (this.batchErrorHandler instanceof FallbackBatchErrorHandler) {
            ((FallbackBatchErrorHandler)this.batchErrorHandler).onPartitionsAssigned(consumer, partitions, publishPause);
        }
    }

    @Override
    protected void notRetryable(Stream<Class<? extends Exception>> notRetryable) {
        if (this.batchErrorHandler instanceof ExceptionClassifier) {
            notRetryable.forEach(ex -> ((ExceptionClassifier)((Object)this.batchErrorHandler)).addNotRetryableExceptions((Class<? extends Exception>)ex));
        }
    }

    @Override
    public void setClassifications(Map<Class<? extends Throwable>, Boolean> classifications, boolean defaultValue) {
        super.setClassifications(classifications, defaultValue);
        if (this.batchErrorHandler instanceof ExceptionClassifier) {
            ((ExceptionClassifier)((Object)this.batchErrorHandler)).setClassifications(classifications, defaultValue);
        }
    }

    @Override
    @Nullable
    public Boolean removeClassification(Class<? extends Exception> exceptionType) {
        Boolean removed = super.removeClassification(exceptionType);
        if (this.batchErrorHandler instanceof ExceptionClassifier) {
            ((ExceptionClassifier)((Object)this.batchErrorHandler)).removeClassification(exceptionType);
        }
        return removed;
    }
}

