/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.common.monitoring.undertow.configuration;

import io.micrometer.core.instrument.MeterRegistry;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.handlers.MetricsHandler;
import org.qubership.atp.common.monitoring.undertow.metrics.UndertowConnectorMetrics;
import org.qubership.atp.common.monitoring.undertow.metrics.UndertowMetrics;
import org.qubership.atp.common.monitoring.undertow.metrics.UndertowMetricsHandlerWrapper;
import org.qubership.atp.common.monitoring.undertow.metrics.UndertowRequestMetrics;
import org.qubership.atp.common.monitoring.undertow.metrics.UndertowSessionMetrics;
import org.qubership.atp.common.monitoring.undertow.metrics.UndertowXWorkerMetrics;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.web.embedded.undertow.UndertowBuilderCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowWebServer;
import org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={Undertow.class})
public class UndertowMetricsAutoConfiguration
implements ApplicationListener<ApplicationReadyEvent> {
    @Bean
    public UndertowBuilderCustomizer undertowBuilderCustomizerEnableStatistics() {
        return builder -> builder.setServerOption(UndertowOptions.ENABLE_STATISTICS, (Object)true);
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        UndertowWebServer undertowWebServer = UndertowMetrics.findUndertowWebServer(event.getApplicationContext());
        if (undertowWebServer == null) {
            return;
        }
        Undertow undertow = UndertowMetrics.getUndertow(undertowWebServer);
        if (undertow == null) {
            return;
        }
        MeterRegistry registry = (MeterRegistry)event.getApplicationContext().getBean(MeterRegistry.class);
        new UndertowConnectorMetrics(undertowWebServer).bindTo(registry);
        new UndertowSessionMetrics(undertowWebServer).bindTo(registry);
        new UndertowXWorkerMetrics(undertowWebServer).bindTo(registry);
        if (event.getApplicationContext() instanceof ServletWebServerApplicationContext) {
            MetricsHandler metricsHandler = UndertowMetricsHandlerWrapper.getMetricsHandler(((ServletWebServerApplicationContext)event.getApplicationContext()).getServletContext());
            new UndertowRequestMetrics(metricsHandler).bindTo(registry);
        }
    }
}

