/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.util.logging.Logger;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.DataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.DriverConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.logging.annotations.DefaultLogger;
import oracle.ucp.logging.annotations.Feature;
import oracle.ucp.logging.annotations.Supports;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.jdbc")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public abstract class ConnectionConnectionPool
extends JDBCConnectionPool {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    public ConnectionConnectionPool(JDBCConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        super(connectionFactoryAdapter);
        if (!(connectionFactoryAdapter instanceof DataSourceConnectionFactoryAdapter) && !(connectionFactoryAdapter instanceof DriverConnectionFactoryAdapter)) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(103);
        }
    }

    public Connection getConnection(JDBCConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        Connection conn = (Connection)this.borrowConnection(connectionRetrievalInfo).getPhysicalConnection();
        ClioSupport.ilogFinest(null, null, null, null, "connection borrowed succesfully");
        return conn;
    }

    public boolean returnConnection(Connection connection) throws UniversalConnectionPoolException {
        boolean res = this.returnUsedPhysicalConnection(connection);
        ClioSupport.ilogFinest(null, null, null, null, "connection returned succesfully");
        return res;
    }

    public boolean closeConnection(Connection connection) throws UniversalConnectionPoolException {
        boolean res = this.closeUsedPhysicalConnection(connection);
        ClioSupport.ilogFinest(null, null, null, null, "connection closed succesfully");
        return res;
    }

    static {
        try {
            $$$methodRef$$$3 = ConnectionConnectionPool.class.getDeclaredConstructor(JDBCConnectionFactoryAdapter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = ConnectionConnectionPool.class.getDeclaredMethod("closeConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = ConnectionConnectionPool.class.getDeclaredMethod("returnConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = ConnectionConnectionPool.class.getDeclaredMethod("getConnection", JDBCConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

