/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.controllers;

import java.io.File;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.qubership.atp.ei.ntt.controllers.ModelItemController;
import org.qubership.atp.ei.ntt.model.ContextVariable;
import org.qubership.atp.ei.ntt.model.DataSet;
import org.qubership.atp.ei.ntt.model.ModelItem;
import org.qubership.atp.ei.ntt.model.Project;
import org.qubership.atp.ei.ntt.model.impl.ContextVariableImpl;
import org.qubership.atp.ei.ntt.model.impl.DataSetModel;
import org.qubership.atp.ei.ntt.utils.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetController {
    private static final Logger log = LoggerFactory.getLogger(DataSetController.class);
    private static DataSetController instance = null;

    protected DataSetController() {
    }

    public static synchronized DataSetController getInstance() {
        if (instance == null) {
            instance = new DataSetController();
        }
        return instance;
    }

    public void load(Project project, List<String> dataSetPath) {
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
        switch (project.getProjectType().toLowerCase()) {
            case "txt": {
                try {
                    File dsFile = new File(dataSetPath.iterator().next());
                    if (!dsFile.exists()) {
                        FileWriter wr = new FileWriter(dsFile);
                        wr.write("dsName=DataSet1\n\nname=var1; value=1");
                        ((Writer)wr).flush();
                        ((Writer)wr).close();
                    }
                    CSVFormat csvFormat = CSVFormat.newFormat((char)';').withCommentMarker('#').withQuote('\"');
                    CSVParser dsParser = new CSVParser((Reader)CommonUtils.getReaderForFile(dsFile), csvFormat);
                    boolean dsFound = false;
                    LinkedList<ContextVariable> contVar = new LinkedList<ContextVariable>();
                    DataSet dataSet = null;
                    for (CSVRecord ss : dsParser.getRecords()) {
                        if (ss.size() == 1 && ss.get(0).startsWith("dsName")) {
                            if (dataSet != null && contVar.size() > 0) {
                                dataSet.setVariables(contVar);
                                dataSets.add(dataSet);
                            }
                            dataSet = this.createEmptyDataSet(project, new Object[0]);
                            dataSet.setName(ss.get(0).substring(ss.get(0).indexOf(61) + 1));
                            contVar = new LinkedList();
                            dsFound = true;
                        }
                        if (!dsFound || ss.size() < 2) continue;
                        ContextVariableImpl var = new ContextVariableImpl();
                        for (String s : ss) {
                            if (!s.contains("=")) continue;
                            String[] dsVals = s.trim().split("=");
                            String val1 = dsVals.length >= 1 ? dsVals[0] : "";
                            String val2 = dsVals.length > 1 ? dsVals[1] : "";
                            switch (val1) {
                                case "name": {
                                    var.setName(val2);
                                    break;
                                }
                                case "description": {
                                    var.setDescription(val2);
                                    break;
                                }
                                case "value": {
                                    var.setValue(val2);
                                    break;
                                }
                            }
                        }
                        contVar.add(var);
                    }
                    if (dataSet != null) {
                        if (contVar.size() > 0) {
                            dataSet.setVariables(contVar);
                        }
                        dataSets.add(dataSet);
                    }
                    if (dataSets.size() <= 0) break;
                    project.setCurrentDataSet((DataSet)dataSets.get(0));
                }
                catch (Exception e) {
                    log.error("Load TXT ATPDataSet", (Throwable)e);
                }
                break;
            }
        }
    }

    public DataSet createEmptyDataSet(Project project, Object ... helpArgs) {
        DataSetModel dataSet = new DataSetModel(project, this.getDefaultName(project, new Object[0]));
        ModelItemController.getInstance().calculateNewNodeName(dataSet, project, new Object[0]);
        this.addDataSet(project, dataSet);
        return dataSet;
    }

    public String getDefaultName(ModelItem project, Object ... helpArgs) {
        return "Data Set";
    }

    private void addDataSet(Project project, DataSet dataSet) {
        dataSet.setProject(project);
        project.getDataSets().add(dataSet);
    }
}

