/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.settings.model.dal.support;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.ei.ntt.settings.ReflectionUtils;
import org.qubership.atp.ei.ntt.settings.model.FileSettings;
import org.qubership.atp.ei.ntt.settings.model.Option;
import org.qubership.atp.ei.ntt.settings.model.dal.Associable;
import org.qubership.atp.ei.ntt.settings.model.dal.FiledStorer;
import org.qubership.atp.ei.ntt.settings.model.dal.Resource;
import org.qubership.atp.ei.ntt.settings.model.dal.jdom.JDomStorer;
import org.qubership.atp.ei.ntt.settings.model.dal.support.XmlDaoFactory;

public abstract class DaoFactory {
    private static DaoFactory instance;

    @Nonnull
    public static DaoFactory getInstance() {
        if (instance == null) {
            instance = new XmlDaoFactory();
        }
        return instance;
    }

    public abstract <T extends Resource> T load(Class<T> var1);

    public abstract <T extends ElementDal> T load(Resource var1);

    public abstract <T extends XmlResource> T loadResource(T var1);

    public abstract <T extends ElementDal> T get(XmlResource var1);

    @Nullable
    public abstract <T extends ElementDal> T get(XmlResource var1, Class<T> var2);

    public abstract <T extends ElementDal> T set(T var1);

    public abstract <T extends Resource> T set(T var1);

    public abstract <T extends XmlResource> boolean save(T var1);

    public abstract <T extends ElementDal> boolean save(T var1);

    public static abstract class NamedElementDal
    extends AbstractElementDal
    implements NamedDal {
        @Option(key="./@name")
        private String name;
        @Option(key="./@description")
        private String description;

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public void setDescription(String description) {
            this.description = description;
        }
    }

    public static interface Versioned {
        public String getCermVersion();

        public void setCermVersion(String var1);
    }

    public static interface NamedDal {
        public String getName();

        public void setName(String var1);

        public String getDescription();

        public void setDescription(String var1);
    }

    public static abstract class AbstractElementDal
    implements ElementDal {
        private Resource resource;

        @Override
        public Resource getResource() {
            return this.resource;
        }

        @Override
        public void setResource(Resource resource) {
            this.resource = resource;
        }
    }

    public static interface ElementDal {
        public Resource getResource();

        public void setResource(Resource var1);
    }

    public static abstract class DomXmlResource
    extends XmlResource {
        private JDomStorer domStorer = new JDomStorer(this);

        public DomXmlResource() {
        }

        public DomXmlResource(String filePath) {
            super(filePath);
        }

        @Override
        public Associable getAssociable() {
            return this.domStorer;
        }

        @Override
        public FiledStorer getStorer() {
            return this.domStorer;
        }
    }

    public static abstract class XmlResource
    implements Resource {
        protected List<ElementDal> children = new ArrayList<ElementDal>();
        private FileSettings fileSettings;

        @Override
        public DaoFactory getFactory() {
            return DaoFactory.getInstance();
        }

        public XmlResource() {
        }

        public XmlResource(String filePath) {
            this();
            File tmpFile = new File(filePath);
            filePath = tmpFile.getAbsolutePath();
            this.setFileSettings(filePath);
        }

        public abstract Associable getAssociable();

        public abstract FiledStorer getStorer();

        @Override
        public FileSettings getFileSettings() {
            return this.fileSettings;
        }

        @Override
        public void setFileSettings(String filePath) {
            this.fileSettings = new FileSettings(filePath);
        }

        @Override
        public void setFileSettings(File file) {
            this.fileSettings = new FileSettings(file);
        }

        public abstract String getRootElementName();

        @Override
        public <T extends ElementDal> List<T> getChildren() {
            return this.children;
        }

        @Override
        public <T extends ElementDal> void setChild(T obj) {
            boolean find = false;
            for (ElementDal element : this.children) {
                if (!element.getClass().equals(obj.getClass())) continue;
                int index = this.children.indexOf(element);
                this.children.set(index, obj);
                find = true;
                break;
            }
            if (!find) {
                this.children.add(obj);
            }
            obj.setResource(this);
        }

        @Override
        public <T extends ElementDal> T getChild(Class<T> clazz) {
            for (ElementDal element : this.children) {
                if (!element.getClass().equals(clazz)) continue;
                return (T)element;
            }
            ElementDal element = (ElementDal)ReflectionUtils.getInstance(clazz);
            this.children.add(element);
            return (T)element;
        }
    }
}

