/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.security.oauth2.client.config;

import org.qubership.atp.auth.springbootstarter.security.oauth2.client.relay.NoClientOAuth2ProtectedResourceDetails;
import org.qubership.atp.auth.springbootstarter.security.oauth2.client.relay.TokenRelayKeycloakClientContext;
import org.qubership.atp.common.logging.interceptor.RestTemplateLogInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.DefaultAccessTokenRequest;
import org.springframework.web.client.RestTemplate;

@Configuration
@Profile(value={"default"})
public class TokenRelayConfiguration {
    @Bean(value={"relayRestTemplate"})
    public RestTemplate relayRestTemplate(ClientHttpRequestFactory sslRequestFactory, RestTemplateLogInterceptor restTemplateLogInterceptor) {
        OAuth2RestTemplate restTemplate = new OAuth2RestTemplate((OAuth2ProtectedResourceDetails)new NoClientOAuth2ProtectedResourceDetails(), (OAuth2ClientContext)new TokenRelayKeycloakClientContext((AccessTokenRequest)new DefaultAccessTokenRequest()));
        restTemplate.setRequestFactory((ClientHttpRequestFactory)new BufferingClientHttpRequestFactory(sslRequestFactory));
        restTemplate.getInterceptors().add(restTemplateLogInterceptor);
        return restTemplate;
    }
}

