/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.ssl;

import com.sun.net.ssl.KeyManager;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.security.KeyStore;
import java.security.Security;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import oracle.security.pki.OraclePKIProvider;
import oracle.security.pki.ssl.ClassServer;

public class ClassFileServer
extends ClassServer {
    private String a;
    private static int b = 2001;
    private int c;
    private int d = 0;

    public ClassFileServer(ServerSocket serverSocket, String string, int n) throws IOException {
        super(serverSocket);
        this.a = string;
        this.c = n;
    }

    @Override
    public byte[] getBytes(String string) throws IOException {
        FilterInputStream filterInputStream = null;
        System.out.println("reading: " + string);
        try {
            File file = new File(this.a + File.separator + string);
            int n = (int)file.length();
            if (n == 0) {
                throw new IOException("File length is zero: " + string);
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            filterInputStream = new DataInputStream(fileInputStream);
            byte[] byArray = new byte[n];
            ((DataInputStream)filterInputStream).readFully(byArray);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (Exception exception) {
                System.out.println("Error closing data input stream.");
            }
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("USAGE: java ClassFileServer port docroot numOfConns [TLS [true]]");
        System.out.println("");
        System.out.println("If the third argument is TLS, it will start as\na TLS/SSL file server, otherwise, it will be\nan ordinary file server. \nIf the fourth argument is true,it will require\nclient authentication as well.");
        int n = b;
        String string = "";
        int n2 = 1;
        if (stringArray.length >= 1) {
            n = Integer.parseInt(stringArray[0]);
        }
        if (stringArray.length >= 2) {
            string = stringArray[1];
        }
        if (stringArray.length >= 3) {
            n2 = Integer.parseInt(stringArray[2]);
        }
        String string2 = "PlainSocket";
        if (stringArray.length >= 4) {
            string2 = stringArray[3];
        }
        try {
            ServerSocketFactory serverSocketFactory = ClassFileServer.a(string2);
            ServerSocket serverSocket = serverSocketFactory.createServerSocket(n);
            if (stringArray.length >= 4 && stringArray[4].equals("true")) {
                ((SSLServerSocket)serverSocket).setNeedClientAuth(true);
            }
            ClassFileServer classFileServer = new ClassFileServer(serverSocket, string, n2);
            classFileServer.start();
            classFileServer.waitForCompletion();
        }
        catch (IOException iOException) {
            System.out.println("Unable to start ClassServer: " + iOException.getMessage());
            iOException.printStackTrace(System.out);
        }
    }

    @Override
    protected synchronized void a() {
        if (this.c > 0) {
            ++this.d;
            --this.c;
            super.a();
        }
    }

    @Override
    public void run() {
        super.run();
        this.b();
    }

    private synchronized void b() {
        --this.d;
        this.notifyAll();
    }

    public synchronized void waitForCompletion() {
        while (this.d > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ServerSocketFactory a(String string) {
        if (!string.equals("TLS")) return ServerSocketFactory.getDefault();
        FileInputStream fileInputStream = null;
        FileInputStream fileInputStream2 = null;
        SSLServerSocketFactory sSLServerSocketFactory = null;
        try {
            Object object;
            Object object2;
            Security.insertProviderAt(new OraclePKIProvider(), 1);
            Security.insertProviderAt(Security.getProvider("SunJSSE"), 2);
            KeyStore keyStore = KeyStore.getInstance(System.getProperty("javax.net.ssl.trustStoreType"), "OraclePKI");
            fileInputStream = new FileInputStream(System.getProperty("javax.net.ssl.trustStore"));
            keyStore.load(fileInputStream, System.getProperty("javax.net.ssl.trustStorePassword", "").toCharArray());
            String string2 = System.getProperty("test.trustmanager.algorithm", TrustManagerFactory.getDefaultAlgorithm());
            System.out.println("Using TrustManagerFactory =" + string2);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance((String)string2);
            trustManagerFactory.init(keyStore);
            TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
            KeyManager[] keyManagerArray = null;
            if (System.getProperty("javax.net.ssl.keyStore") != null) {
                object2 = KeyStore.getInstance(System.getProperty("javax.net.ssl.keyStoreType"), "OraclePKI");
                fileInputStream2 = new FileInputStream(System.getProperty("javax.net.ssl.keyStore"));
                ((KeyStore)object2).load(fileInputStream2, System.getProperty("javax.net.ssl.keyStorePassword", "").toCharArray());
                object = System.getProperty("test.keymanager.algorithm", KeyManagerFactory.getDefaultAlgorithm());
                System.out.println("Using KeyManagerFactory = " + (String)object);
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance((String)object);
                keyManagerFactory.init((KeyStore)object2, System.getProperty("javax.net.ssl.trustStorePassword", "").toCharArray());
                keyManagerArray = keyManagerFactory.getKeyManagers();
            }
            object2 = SSLContext.getInstance((String)"SSL");
            object2.init(keyManagerArray, trustManagerArray, null);
            sSLServerSocketFactory = object2.getServerSocketFactory();
            object = sSLServerSocketFactory;
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (fileInputStream2 != null) {
                    fileInputStream2.close();
                }
            }
            catch (Exception exception) {
                System.out.println("Error closing file input stream.");
            }
        }
    }
}

