/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.polyjdbc.core.DefaultPolyJDBC;
import org.polyjdbc.core.PolyJDBC;
import org.polyjdbc.core.dialect.Dialect;
import org.polyjdbc.core.transaction.ConnectionProvider;
import org.polyjdbc.core.transaction.DataSourceTransactionManager;
import org.polyjdbc.core.transaction.ExternalTransactionManager;
import org.polyjdbc.core.transaction.TransactionManager;
import org.polyjdbc.core.type.ColumnTypeMapper;
import org.polyjdbc.core.type.SqlType;

public final class PolyJDBCBuilder {
    private final Dialect dialect;
    private String schemaName;
    private final Map<Class<?>, SqlType> customMappings = new HashMap();
    private DataSource dataSource;
    private ConnectionProvider connectionProvider;

    private PolyJDBCBuilder(Dialect dialect) {
        this(dialect, null);
    }

    private PolyJDBCBuilder(Dialect dialect, String schemaName) {
        this.dialect = dialect;
        this.schemaName = schemaName;
    }

    public static PolyJDBCBuilder polyJDBC(Dialect dialect) {
        return new PolyJDBCBuilder(dialect);
    }

    public static PolyJDBCBuilder polyJDBC(Dialect dialect, String schemaName) {
        return new PolyJDBCBuilder(dialect, schemaName);
    }

    public PolyJDBC build() {
        TransactionManager manager = this.dataSource != null ? new DataSourceTransactionManager(this.dataSource) : new ExternalTransactionManager(this.connectionProvider);
        return new DefaultPolyJDBC(this.dialect, this.schemaName, new ColumnTypeMapper(this.customMappings), manager);
    }

    public PolyJDBCBuilder connectingToDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public PolyJDBCBuilder usingManagedConnections(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
        return this;
    }

    public PolyJDBCBuilder withCustomMapping(Class<?> clazz, SqlType sqlType) {
        this.customMappings.put(clazz, sqlType);
        return this;
    }
}

