/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core.dialect;

import org.polyjdbc.core.dialect.DB2400Dialect;
import org.polyjdbc.core.dialect.DB2Dialect;
import org.polyjdbc.core.dialect.Dialect;
import org.polyjdbc.core.dialect.H2Dialect;
import org.polyjdbc.core.dialect.MsSqlDialect;
import org.polyjdbc.core.dialect.MysqlDialect;
import org.polyjdbc.core.dialect.OracleDialect;
import org.polyjdbc.core.dialect.PostgresDialect;

public enum DialectRegistry {
    H2(new H2Dialect()),
    POSTGRES(new PostgresDialect()),
    MYSQL(new MysqlDialect()),
    MSSQL(new MsSqlDialect()),
    ORACLE(new OracleDialect()),
    DB2(new DB2Dialect()),
    DB2400(new DB2400Dialect());

    private final Dialect dialect;

    private DialectRegistry(Dialect dialect) {
        this.dialect = dialect;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public static Dialect dialect(String dialectCode) {
        return DialectRegistry.valueOf(dialectCode).getDialect();
    }
}

