/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core.key;

import java.sql.SQLException;
import org.polyjdbc.core.exception.SequenceLimitReachedException;
import org.polyjdbc.core.key.SequenceNextValQuery;
import org.polyjdbc.core.transaction.Transaction;

final class Sequence {
    private final String sequenceName;
    private long currentValue;
    private long currentLimit = -1L;
    private final long allocationSize;

    Sequence(String sequenceName, long allocationSize) {
        this.allocationSize = allocationSize;
        this.sequenceName = sequenceName;
    }

    synchronized long nextValue(SequenceNextValQuery sequenceNextValQuery, Transaction transaction) throws SQLException {
        if (this.recalculationNeeded()) {
            long currentSequenceValue = sequenceNextValQuery.queryForNextVal(this.sequenceName, transaction);
            this.recalculate(currentSequenceValue);
        }
        return this.nextLocalValue();
    }

    long nextLocalValue() {
        if (this.recalculationNeeded()) {
            throw new SequenceLimitReachedException("Sequence " + this.sequenceName + " has reached its limit of " + this.currentLimit + ". Before fetching value, check if recalculation is needed using recalculationNeeded() method.");
        }
        ++this.currentValue;
        return this.currentValue - 1L;
    }

    void recalculate(long currentSequenceValue) {
        this.currentValue = this.allocationSize * currentSequenceValue;
        this.currentLimit = this.allocationSize * (currentSequenceValue + 1L) - 1L;
    }

    boolean recalculationNeeded() {
        return this.currentValue > this.currentLimit;
    }
}

