/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core.transaction;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.polyjdbc.core.exception.PolyJdbcException;
import org.polyjdbc.core.transaction.TransactionState;

class ManagedTransactionState
implements TransactionState {
    private final Connection connection;
    private final List<Statement> statements = new ArrayList<Statement>();
    private final List<ResultSet> resultSets = new ArrayList<ResultSet>();

    ManagedTransactionState(Connection connection) {
        this.connection = connection;
    }

    @Override
    public void registerStatement(Statement statement) {
        this.statements.add(0, statement);
    }

    @Override
    public void registerCursor(ResultSet resultSet) {
        this.resultSets.add(0, resultSet);
    }

    @Override
    public void commit() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.commit();
            }
        }
        catch (SQLException exception) {
            throw new PolyJdbcException("TRANSACTION_COMMIT_ERROR", "Failed to commit transaction transaction.", exception);
        }
    }

    @Override
    public void rollback() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.rollback();
            }
        }
        catch (SQLException exception) {
            throw new PolyJdbcException("TRANSACTION_ROLLBACK_ERROR", "Failed to rollback transaction.", exception);
        }
    }

    @Override
    public void close() {
        try {
            if (this.connection != null && this.connection.isClosed()) {
                throw new PolyJdbcException("CLOSING_CLOSED_CONNECTION", "Tried to close already closed connection! Check for some unwanted close() in your code.");
            }
            for (ResultSet resultSet : this.resultSets) {
                resultSet.close();
            }
            for (Statement statement : this.statements) {
                statement.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException exception) {
            throw new PolyJdbcException("TRANSACTION_CLOSE_ERROR", "Failed to close transaction.", exception);
        }
    }
}

