/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core.transaction;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.polyjdbc.core.transaction.TransactionState;

public class Transaction
implements Closeable {
    private final Connection connection;
    private final TransactionState transactionState;

    Transaction(Connection connection, TransactionState transactionState) {
        this.connection = connection;
        this.transactionState = transactionState;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public int executeUpdate(PreparedStatement preparedStatement) throws SQLException {
        try {
            this.registerStatement(preparedStatement);
            return preparedStatement.executeUpdate();
        }
        catch (SQLException exception) {
            this.transactionState.rollback();
            throw exception;
        }
    }

    public boolean execute(PreparedStatement preparedStatement) throws SQLException {
        try {
            this.registerStatement(preparedStatement);
            return preparedStatement.execute();
        }
        catch (SQLException exception) {
            this.transactionState.rollback();
            throw exception;
        }
    }

    public ResultSet executeQuery(PreparedStatement preparedStatement) throws SQLException {
        try {
            this.registerStatement(preparedStatement);
            ResultSet resultSet = preparedStatement.executeQuery();
            this.registerCursor(resultSet);
            return resultSet;
        }
        catch (SQLException exception) {
            this.transactionState.rollback();
            throw exception;
        }
    }

    public PreparedStatement prepareStatement(String query) throws SQLException {
        try {
            return this.connection.prepareStatement(query);
        }
        catch (SQLException exception) {
            this.transactionState.rollback();
            throw exception;
        }
    }

    public Statement createStatement() throws SQLException {
        try {
            Statement statement = this.connection.createStatement();
            this.registerStatement(statement);
            return statement;
        }
        catch (SQLException exception) {
            this.transactionState.rollback();
            throw exception;
        }
    }

    public void registerStatement(Statement statement) {
        this.transactionState.registerStatement(statement);
    }

    public void registerCursor(ResultSet resultSet) {
        this.transactionState.registerCursor(resultSet);
    }

    public void commit() {
        this.transactionState.commit();
    }

    public void rollback() {
        this.transactionState.rollback();
    }

    @Override
    public void close() {
        this.transactionState.close();
    }
}

