/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core.type;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.polyjdbc.core.exception.UnknownColumnTypeException;
import org.polyjdbc.core.type.SqlType;
import org.polyjdbc.core.type.Timestamp;

public class ColumnTypeMapper {
    private final Map<Class<?>, SqlType> mappings = new HashMap();

    public ColumnTypeMapper() {
        this.registerDefaultMappings();
    }

    public ColumnTypeMapper(Map<Class<?>, SqlType> mappings) {
        this();
        this.mappings.putAll(mappings);
    }

    private void registerDefaultMappings() {
        this.mappings.put(String.class, new SqlType(12));
        this.mappings.put(Integer.class, new SqlType(4));
        this.mappings.put(Long.class, new SqlType(-5));
        this.mappings.put(Float.class, new SqlType(6));
        this.mappings.put(Character.class, new SqlType(1));
        this.mappings.put(Boolean.class, new SqlType(16));
        this.mappings.put(Date.class, new SqlType(91));
        this.mappings.put(BigDecimal.class, new SqlType(2));
        this.mappings.put(java.sql.Timestamp.class, new SqlType(91));
        this.mappings.put(Timestamp.class, new SqlType(93));
    }

    public SqlType forClass(Class<?> objectClass) {
        for (Map.Entry<Class<?>, SqlType> entry : this.mappings.entrySet()) {
            if (!entry.getKey().isAssignableFrom(objectClass)) continue;
            return entry.getValue();
        }
        throw new UnknownColumnTypeException("Could not find column type matching class " + objectClass.getCanonicalName() + ". Make sure class is assignable from any of supported classes.");
    }

    public SqlType forObject(Object object) {
        return this.forClass(object.getClass());
    }
}

