/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core.util;

import java.util.HashSet;
import java.util.Set;

public final class TypeUtil {
    private static final Set<Class<?>> PRIMITIVE_WRAPPERS = new HashSet();

    private TypeUtil() {
    }

    public static boolean isPrimitiveOrWrapper(Object object) {
        return object.getClass().isPrimitive() || PRIMITIVE_WRAPPERS.contains(object.getClass());
    }

    public static boolean isNonQuotablePrimitive(Object object) {
        return TypeUtil.isPrimitiveOrWrapper(object) && object.getClass() != Character.class;
    }

    static {
        PRIMITIVE_WRAPPERS.add(Boolean.class);
        PRIMITIVE_WRAPPERS.add(Character.class);
        PRIMITIVE_WRAPPERS.add(Byte.class);
        PRIMITIVE_WRAPPERS.add(Short.class);
        PRIMITIVE_WRAPPERS.add(Integer.class);
        PRIMITIVE_WRAPPERS.add(Long.class);
        PRIMITIVE_WRAPPERS.add(Float.class);
        PRIMITIVE_WRAPPERS.add(Double.class);
        PRIMITIVE_WRAPPERS.add(Void.class);
    }
}

