/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.common.lock.config;

import net.javacrumbs.shedlock.core.LockProvider;
import org.qubership.atp.common.lock.LockManager;
import org.qubership.atp.common.lock.provider.InMemoryLockProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AtpLockConfig {
    @Value(value="${atp.lock.default.duration.sec:60}")
    private Integer defaultLockDurationSec;
    @Value(value="${atp.lock.retry.timeout.sec:10800}")
    private Integer retryTimeoutSec;
    @Value(value="${atp.lock.retry.pace.sec:3}")
    private Integer retryPaceSec;

    @Bean
    @ConditionalOnMissingBean
    public LockProvider lockProvider() {
        return new InMemoryLockProvider();
    }

    @Bean
    public LockManager lockManager(LockProvider lockProvider) {
        return new LockManager(this.defaultLockDurationSec, this.retryTimeoutSec, this.retryPaceSec, lockProvider);
    }
}

