/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.db.modification;

import com.google.common.collect.ImmutableMap;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.qubership.atp.environments.model.Connection;
import org.qubership.atp.environments.model.Environment;
import org.qubership.atp.environments.model.Identified;
import org.qubership.atp.environments.model.Project;
import org.qubership.atp.environments.model.System;

public enum TrackedType {
    PROJECT("Project", Project.class, "project"),
    ENVIRONMENT("Environment", Environment.class, "environment"),
    SYSTEM("System", System.class, "system"),
    CONNECTION("Connection", Connection.class, "system");

    private static final ImmutableMap<String, TrackedType> BY_NAME;
    public final String name;
    public final Class<? extends Identified> entityType;
    public final String entityForNotice;

    private TrackedType(String name, Class<? extends Identified> entityType, String entityForNotice) {
        this.name = name;
        this.entityType = entityType;
        this.entityForNotice = entityForNotice;
    }

    public static Optional<TrackedType> getByName(String name) {
        return Optional.ofNullable((TrackedType)((Object)BY_NAME.get((Object)name)));
    }

    static {
        BY_NAME = new ImmutableMap.Builder().putAll((Iterable)Arrays.stream(TrackedType.values()).map(type -> new AbstractMap.SimpleEntry<String, TrackedType>(type.name, (TrackedType)((Object)type))).collect(Collectors.toList())).build();
    }
}

