/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.repo.impl;

import com.google.common.base.Preconditions;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MappingProjection;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Timestamp;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.qubership.atp.environments.model.EnvironmentCategory;
import org.qubership.atp.environments.model.impl.EnvironmentCategoryImpl;
import org.qubership.atp.environments.repo.impl.AbstractRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class EnvironmentCategoryRepositoryImpl
extends AbstractRepository {
    private final SQLQueryFactory queryFactory;
    private final EnvironmentCategoryProjection projection = new EnvironmentCategoryProjection(this);

    @Autowired
    public EnvironmentCategoryRepositoryImpl(SQLQueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    @Nonnull
    public EnvironmentCategory getById(@Nonnull UUID id) {
        return (EnvironmentCategory)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)ENVIRONMENT_CATEGORIES)).where((Predicate)EnvironmentCategoryRepositoryImpl.ENVIRONMENT_CATEGORIES.id.eq((Object)id))).fetchOne();
    }

    public boolean existsById(@Nonnull UUID id) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)ENVIRONMENT_CATEGORIES)).where((Predicate)EnvironmentCategoryRepositoryImpl.ENVIRONMENT_CATEGORIES.id.eq((Object)id))).fetchCount() > 0L;
    }

    @Nonnull
    public List<EnvironmentCategory> getAll() {
        return ((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)ENVIRONMENT_CATEGORIES)).fetch();
    }

    @Nonnull
    public EnvironmentCategory create(@Nonnull String name, String description, String tagList, Long created) {
        Timestamp createdTimestamp = new Timestamp(created);
        UUID id = (UUID)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)ENVIRONMENT_CATEGORIES).set((Path)EnvironmentCategoryRepositoryImpl.ENVIRONMENT_CATEGORIES.name, (Object)name)).set((Path)EnvironmentCategoryRepositoryImpl.ENVIRONMENT_CATEGORIES.description, (Object)description)).set((Path)EnvironmentCategoryRepositoryImpl.ENVIRONMENT_CATEGORIES.tagList, (Object)tagList)).set((Path)EnvironmentCategoryRepositoryImpl.ENVIRONMENT_CATEGORIES.created, (Object)createdTimestamp)).executeWithKey((Path)EnvironmentCategoryRepositoryImpl.ENVIRONMENT_CATEGORIES.id);
        return this.projection.create(id, name, description, tagList, createdTimestamp, null);
    }

    @Nonnull
    public EnvironmentCategory update(@Nonnull UUID id, @Nonnull String name, String description, String tagList, Long modified) {
        Timestamp modifiedTimestamp = new Timestamp(modified);
        long update = ((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)ENVIRONMENT_CATEGORIES).set((Path)EnvironmentCategoryRepositoryImpl.ENVIRONMENT_CATEGORIES.name, (Object)name)).set((Path)EnvironmentCategoryRepositoryImpl.ENVIRONMENT_CATEGORIES.description, (Object)description)).set((Path)EnvironmentCategoryRepositoryImpl.ENVIRONMENT_CATEGORIES.tagList, (Object)tagList)).set((Path)EnvironmentCategoryRepositoryImpl.ENVIRONMENT_CATEGORIES.modified, (Object)modifiedTimestamp)).where((Predicate)EnvironmentCategoryRepositoryImpl.ENVIRONMENT_CATEGORIES.id.eq((Object)id))).execute();
        Timestamp created = (Timestamp)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)EnvironmentCategoryRepositoryImpl.ENVIRONMENT_CATEGORIES.created).from((Expression)ENVIRONMENT_CATEGORIES)).where((Predicate)EnvironmentCategoryRepositoryImpl.ENVIRONMENT_CATEGORIES.id.eq((Object)id))).fetchOne();
        Preconditions.checkArgument((update > 0L ? 1 : 0) != 0, (Object)"Nothing updated");
        return this.projection.create(id, name, description, tagList, created, modifiedTimestamp);
    }

    public void delete(UUID id) {
        this.deleteReferenceToTable(id, (RelationalPathBase)ENVIRONMENT_CATEGORIES, (SimplePath<UUID>)EnvironmentCategoryRepositoryImpl.ENVIRONMENT_CATEGORIES.id);
    }

    private void deleteReferenceToTable(UUID id, RelationalPathBase path, SimplePath<UUID> simplePath) {
        ((SQLDeleteClause)this.queryFactory.delete((RelationalPath)path).where((Predicate)simplePath.eq((Object)id))).execute();
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private static class EnvironmentCategoryProjection
    extends MappingProjection<EnvironmentCategory> {
        static final long serialVersionUID = 42L;
        private final transient EnvironmentCategoryRepositoryImpl repo;

        private EnvironmentCategoryProjection(EnvironmentCategoryRepositoryImpl repo) {
            super(EnvironmentCategory.class, (Expression[])AbstractRepository.ENVIRONMENT_CATEGORIES.all());
            this.repo = repo;
        }

        protected EnvironmentCategory map(Tuple tuple) {
            UUID uuid = (UUID)tuple.get((Expression)AbstractRepository.ENVIRONMENT_CATEGORIES.id);
            assert (uuid != null);
            String name = (String)tuple.get((Expression)AbstractRepository.ENVIRONMENT_CATEGORIES.name);
            assert (name != null);
            String description = (String)tuple.get((Expression)AbstractRepository.ENVIRONMENT_CATEGORIES.description);
            String tagList = (String)tuple.get((Expression)AbstractRepository.ENVIRONMENT_CATEGORIES.tagList);
            Timestamp created = (Timestamp)tuple.get((Expression)AbstractRepository.ENVIRONMENT_CATEGORIES.created);
            assert (created != null);
            Timestamp modified = (Timestamp)tuple.get((Expression)AbstractRepository.ENVIRONMENT_CATEGORIES.modified);
            return this.create(uuid, name, description, tagList, created, modified);
        }

        protected EnvironmentCategoryImpl create(UUID uuid, String name, String description, String tagList, Timestamp created, Timestamp modified) {
            return new EnvironmentCategoryImpl(uuid, name, description, tagList, Long.valueOf(created.getTime()), modified == null ? null : Long.valueOf(modified.getTime()));
        }
    }
}

