/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.repo.impl;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MappingProjection;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.postgresql.util.PGobject;
import org.qubership.atp.environments.model.Environment;
import org.qubership.atp.environments.model.impl.Context;
import org.qubership.atp.environments.model.impl.EnvironmentImpl;
import org.qubership.atp.environments.repo.impl.AbstractRepository;
import org.qubership.atp.environments.repo.impl.ConnectionRepositoryImpl;
import org.qubership.atp.environments.repo.impl.ContextRepository;
import org.qubership.atp.environments.repo.impl.ProjectRepositoryImpl;
import org.qubership.atp.environments.repo.impl.ProjectionRepository;
import org.qubership.atp.environments.repo.impl.SystemCategoryRepositoryImpl;
import org.qubership.atp.environments.repo.impl.SystemRepositoryImpl;
import org.qubership.atp.environments.repo.mapper.EnvironmentMapper;
import org.qubership.atp.environments.repo.projections.FullEnvironmentProjection;
import org.qubership.atp.environments.repo.projections.GenericEnvironmentProjection;
import org.qubership.atp.environments.repo.projections.LazyEnvironmentProjection;
import org.qubership.atp.environments.repo.projections.ShortEnvironmentProjection;
import org.qubership.atp.environments.service.direct.KafkaService;
import org.qubership.atp.environments.service.rest.server.dto.BaseSearchRequestDto;
import org.qubership.atp.environments.service.rest.server.dto.EventType;
import org.qubership.atp.environments.service.rest.server.request.EnvironmentsWithFilterRequest;
import org.qubership.atp.environments.versioning.service.CommitEntityService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class EnvironmentRepositoryImpl
extends AbstractRepository
implements ProjectionRepository<Environment> {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentRepositoryImpl.class);
    private final SQLQueryFactory queryFactory;
    private final Provider<ProjectRepositoryImpl> projectRepo;
    private final Provider<SystemRepositoryImpl> systemRepo;
    private final Provider<ConnectionRepositoryImpl> connectionRepo;
    private final Provider<SystemCategoryRepositoryImpl> systemCategoryRepo;
    private final CommitEntityService<Environment> commitEntityService;
    private final KafkaService kafkaService;
    private final ContextRepository contextRepository;
    private final FullEnvironmentProjection projection = new FullEnvironmentProjection(this);
    private final LazyEnvironmentProjection lazyProjection = new LazyEnvironmentProjection(this);
    private final ShortEnvironmentProjection shortProjection = new ShortEnvironmentProjection(this);
    private final EnvironmentMapper environmentMapper;

    @Autowired
    public EnvironmentRepositoryImpl(SQLQueryFactory queryFactory, Provider<ProjectRepositoryImpl> projectRepo, Provider<SystemRepositoryImpl> systemRepo, Provider<ConnectionRepositoryImpl> connectionRepo, Provider<SystemCategoryRepositoryImpl> systemCategoryRepo, CommitEntityService<Environment> commitEntityService, KafkaService kafkaService, ContextRepository contextRepository, EnvironmentMapper mapper) {
        this.queryFactory = queryFactory;
        this.projectRepo = projectRepo;
        this.systemRepo = systemRepo;
        this.connectionRepo = connectionRepo;
        this.systemCategoryRepo = systemCategoryRepo;
        this.commitEntityService = commitEntityService;
        this.kafkaService = kafkaService;
        this.contextRepository = contextRepository;
        this.environmentMapper = mapper;
    }

    public Provider<ProjectRepositoryImpl> getProjectRepo() {
        return this.projectRepo;
    }

    public Provider<SystemRepositoryImpl> getSystemRepo() {
        return this.systemRepo;
    }

    @Nullable
    public Environment getById(@Nonnull UUID id) {
        return (Environment)((SQLQuery)((SQLQuery)this.queryFactory.select(this.resolveProjection()).from((Expression)ENVIRONMENTS)).where((Predicate)EnvironmentRepositoryImpl.ENVIRONMENTS.id.eq((Object)id))).fetchOne();
    }

    @Nullable
    public String getNameById(@Nonnull UUID id) {
        return (String)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)EnvironmentRepositoryImpl.ENVIRONMENTS.name).from((Expression)ENVIRONMENTS)).where((Predicate)EnvironmentRepositoryImpl.ENVIRONMENTS.id.eq((Object)id))).fetchOne();
    }

    public boolean existsById(@Nonnull UUID id) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.shortProjection).from((Expression)ENVIRONMENTS)).where((Predicate)EnvironmentRepositoryImpl.ENVIRONMENTS.id.eq((Object)id))).fetchCount() > 0L;
    }

    @Nonnull
    public List<Environment> getAll() {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select(this.resolveProjection()).from((Expression)ENVIRONMENTS)).orderBy(EnvironmentRepositoryImpl.ENVIRONMENTS.name.asc())).fetch();
    }

    @Nonnull
    public List<Environment> getAll(UUID categoryId) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select(this.resolveProjection()).from((Expression)ENVIRONMENTS)).orderBy(EnvironmentRepositoryImpl.ENVIRONMENTS.name.asc())).where((Predicate)EnvironmentRepositoryImpl.ENVIRONMENTS.categoryId.eq((Object)categoryId))).fetch();
    }

    @Nullable
    public List<Environment> getAllByParentId(@Nonnull UUID projectId) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select(this.resolveProjection()).from((Expression)ENVIRONMENTS)).orderBy(EnvironmentRepositoryImpl.ENVIRONMENTS.name.asc())).where((Predicate)EnvironmentRepositoryImpl.ENVIRONMENTS.projectId.eq((Object)projectId))).fetch();
    }

    @Nullable
    public List<Environment> getAllByParentId(@Nonnull UUID projectId, UUID ... categoryIds) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select(this.resolveProjection()).from((Expression)ENVIRONMENTS)).orderBy(EnvironmentRepositoryImpl.ENVIRONMENTS.name.asc())).where((Predicate)EnvironmentRepositoryImpl.ENVIRONMENTS.projectId.eq((Object)projectId).and((Predicate)EnvironmentRepositoryImpl.ENVIRONMENTS.categoryId.in((Object[])categoryIds)))).fetch();
    }

    @Nullable
    public List<Environment> getAllShortByParentId(@Nonnull UUID projectId, UUID ... categoryIds) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.shortProjection).from((Expression)ENVIRONMENTS)).orderBy(EnvironmentRepositoryImpl.ENVIRONMENTS.name.asc())).where((Predicate)EnvironmentRepositoryImpl.ENVIRONMENTS.projectId.eq((Object)projectId).and((Predicate)EnvironmentRepositoryImpl.ENVIRONMENTS.categoryId.in((Object[])categoryIds)))).fetch();
    }

    public List<String> getSystemNamesByProjectId(@Nonnull UUID projectId) {
        ArrayList<String> systemNames = new ArrayList<String>();
        systemNames.addAll(((SystemRepositoryImpl)this.systemRepo.get()).getSystemNamesByProjectId(projectId));
        return systemNames;
    }

    public List<String> getConnectionNamesByProjectId(UUID projectId) {
        ArrayList<String> connectionNames = new ArrayList<String>();
        connectionNames.addAll(((ConnectionRepositoryImpl)this.connectionRepo.get()).getConnectionNameByProjectId(projectId));
        return connectionNames;
    }

    @Nonnull
    public Environment create(@Nonnull UUID environmentId, @Nonnull String name, @Nonnull String graylogName, String description, String ssmSolutionAlias, String ssmInstanceAlias, String consulEgressConfigPath, @Nonnull Long created, @Nonnull UUID createdBy, @Nonnull UUID projectId, @Nonnull UUID categoryId, UUID sourceId, List<String> tags) {
        Timestamp createdTimestamp = new Timestamp(created);
        ((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)ENVIRONMENTS).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.name, (Object)name)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.graylogName, (Object)graylogName)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.description, (Object)description)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.ssmSolutionAlias, (Object)ssmSolutionAlias)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.ssmInstanceAlias, (Object)ssmInstanceAlias)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.consulEgressConfigPath, (Object)consulEgressConfigPath)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.created, (Object)createdTimestamp)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.createdBy, (Object)createdBy)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.modified, (Object)createdTimestamp)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.modifiedBy, (Object)createdBy)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.projectId, (Object)projectId)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.categoryId, (Object)categoryId)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.id, (Object)environmentId)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.sourceId, (Object)sourceId)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.tags, (Object)this.createTagsPgObject(tags))).execute();
        this.updateProjects(projectId, createdTimestamp);
        EnvironmentImpl environment = this.projection.create(environmentId, name, graylogName, description, ssmSolutionAlias, ssmInstanceAlias, consulEgressConfigPath, createdTimestamp, createdBy, createdTimestamp, createdBy, projectId, categoryId, sourceId, tags);
        this.commitEntityService.commit((Environment)environment);
        return environment;
    }

    @Nonnull
    public Environment create(@Nonnull String name, @Nonnull String graylogName, String description, String ssmSolutionAlias, String ssmInstanceAlias, String consulEgressConfigPath, @Nonnull Long created, @Nonnull UUID createdBy, @Nonnull UUID projectId, @Nonnull UUID categoryId, List<String> tags) {
        Timestamp createdTimestamp = new Timestamp(created);
        UUID uuid = (UUID)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)ENVIRONMENTS).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.name, (Object)name)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.graylogName, (Object)graylogName)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.description, (Object)description)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.ssmSolutionAlias, (Object)ssmSolutionAlias)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.ssmInstanceAlias, (Object)ssmInstanceAlias)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.consulEgressConfigPath, (Object)consulEgressConfigPath)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.created, (Object)createdTimestamp)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.createdBy, (Object)createdBy)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.modified, (Object)createdTimestamp)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.modifiedBy, (Object)createdBy)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.projectId, (Object)projectId)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.categoryId, (Object)categoryId)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.tags, (Object)this.createTagsPgObject(tags))).executeWithKey((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.id);
        this.updateProjects(projectId, createdTimestamp);
        EnvironmentImpl environment = this.projection.create(uuid, name, graylogName, description, ssmSolutionAlias, ssmInstanceAlias, consulEgressConfigPath, createdTimestamp, createdBy, createdTimestamp, createdBy, projectId, categoryId, null, tags);
        this.commitEntityService.commit((Environment)environment);
        return environment;
    }

    @Nonnull
    public Environment update(@Nonnull UUID environmentId, @Nonnull String name, @Nonnull String graylogName, String description, String ssmSolutionAlias, String ssmInstanceAlias, String consulEgressConfigPath, @Nonnull Long modified, @Nonnull UUID modifiedBy, @Nonnull UUID projectId, @Nonnull UUID categoryId, List<String> tags) {
        Timestamp modifiedTimestamp = new Timestamp(modified);
        long update = ((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)ENVIRONMENTS).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.name, (Object)name)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.graylogName, (Object)graylogName)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.description, (Object)description)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.ssmSolutionAlias, (Object)ssmSolutionAlias)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.ssmInstanceAlias, (Object)ssmInstanceAlias)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.consulEgressConfigPath, (Object)consulEgressConfigPath)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.modified, (Object)modifiedTimestamp)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.modifiedBy, (Object)modifiedBy)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.projectId, (Object)projectId)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.categoryId, (Object)categoryId)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.tags, (Object)this.createTagsPgObject(tags))).where((Predicate)EnvironmentRepositoryImpl.ENVIRONMENTS.id.eq((Object)environmentId))).execute();
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)this.queryFactory.select(new Expression[]{EnvironmentRepositoryImpl.ENVIRONMENTS.created, EnvironmentRepositoryImpl.ENVIRONMENTS.createdBy, EnvironmentRepositoryImpl.ENVIRONMENTS.sourceId}).from((Expression)ENVIRONMENTS)).where((Predicate)EnvironmentRepositoryImpl.ENVIRONMENTS.id.eq((Object)environmentId))).fetchOne();
        Timestamp created = (Timestamp)tuple.get((Expression)EnvironmentRepositoryImpl.ENVIRONMENTS.created);
        UUID createdBy = (UUID)tuple.get((Expression)EnvironmentRepositoryImpl.ENVIRONMENTS.createdBy);
        UUID sourceId = (UUID)tuple.get((Expression)EnvironmentRepositoryImpl.ENVIRONMENTS.sourceId);
        Preconditions.checkArgument((update > 0L ? 1 : 0) != 0, (Object)"Nothing updated");
        EnvironmentImpl environment = this.projection.create(environmentId, name, graylogName, description, ssmSolutionAlias, ssmInstanceAlias, consulEgressConfigPath, created, createdBy, modifiedTimestamp, modifiedBy, projectId, categoryId, sourceId, tags);
        this.updateEnvironmentsModified(environmentId, modifiedTimestamp, modifiedBy, projectId);
        this.commitEntityService.commit((Environment)environment);
        return environment;
    }

    public void delete(UUID environmentId, Long modified, UUID modifiedBy) {
        Timestamp modifiedTimestamp = new Timestamp(modified);
        UUID projectId = (UUID)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)EnvironmentRepositoryImpl.ENVIRONMENTS.projectId).from((Expression)ENVIRONMENTS)).where((Predicate)EnvironmentRepositoryImpl.ENVIRONMENTS.id.eq((Object)environmentId))).fetchOne();
        this.updateProjects(projectId, modifiedTimestamp);
        ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)EnvironmentRepositoryImpl.ENVIRONMENT_SYSTEMS.systemId).from((Expression)ENVIRONMENT_SYSTEMS)).where((Predicate)EnvironmentRepositoryImpl.ENVIRONMENT_SYSTEMS.environmentId.eq((Object)environmentId))).fetch().forEach(systemId -> ((SystemRepositoryImpl)this.systemRepo.get()).delete((UUID)systemId, environmentId, modified, modifiedBy, false));
        this.kafkaService.sendEnvironmentKafkaNotification(environmentId, EventType.DELETE, projectId);
        this.deleteReferenceToEnvironment(environmentId, (RelationalPathBase)ENVIRONMENTS, (SimplePath<UUID>)EnvironmentRepositoryImpl.ENVIRONMENTS.id);
        this.commitEntityService.delete(environmentId);
    }

    private void deleteReferenceToEnvironment(UUID id, RelationalPathBase path, SimplePath<UUID> simplePath) {
        ((SQLDeleteClause)this.queryFactory.delete((RelationalPath)path).where((Predicate)simplePath.eq((Object)id))).execute();
    }

    public void updateEnvironmentsModified(@Nonnull Environment environment, Timestamp modified, UUID modifiedBy) {
        this.updateEnvironmentsModified(environment.getId(), modified, modifiedBy, environment.getProjectId());
    }

    public void updateEnvironmentsModified(@Nonnull UUID environmentId, Timestamp modified, UUID modifiedBy, UUID projectId) {
        ((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)ENVIRONMENTS).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.modified, (Object)modified)).set((Path)EnvironmentRepositoryImpl.ENVIRONMENTS.modifiedBy, (Object)modifiedBy)).where((Predicate)EnvironmentRepositoryImpl.ENVIRONMENTS.id.eq((Object)environmentId))).execute();
        this.kafkaService.sendEnvironmentKafkaNotification(environmentId, EventType.UPDATE, projectId == null ? this.getProjectId(environmentId) : projectId);
    }

    public UUID getProjectId(UUID environmentId) {
        return (UUID)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)EnvironmentRepositoryImpl.ENVIRONMENTS.projectId).from((Expression)ENVIRONMENTS)).where((Predicate)EnvironmentRepositoryImpl.ENVIRONMENTS.id.eq((Object)environmentId))).fetchOne();
    }

    private void updateProjects(@Nonnull UUID id, Timestamp modified) {
        ((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)PROJECTS).set((Path)EnvironmentRepositoryImpl.PROJECTS.modified, (Object)modified)).where((Predicate)EnvironmentRepositoryImpl.PROJECTS.id.eq((Object)id))).execute();
    }

    @Cacheable(value={"ATP_ENVIRONMENTS-ENVIRONMENTS_BY_SYSTEM_ID"}, key="#systemId", condition="#systemId!=null")
    public List<Environment> getAllBySystemId(UUID systemId) {
        List environmentIds = ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)EnvironmentRepositoryImpl.ENVIRONMENT_SYSTEMS.environmentId).from((Expression)ENVIRONMENT_SYSTEMS)).where((Predicate)EnvironmentRepositoryImpl.ENVIRONMENT_SYSTEMS.systemId.eq((Object)systemId))).fetch();
        return this.getByIds(environmentIds);
    }

    public List<Environment> getAllShortBySystemId(UUID systemId) {
        List environmentIds = ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)EnvironmentRepositoryImpl.ENVIRONMENT_SYSTEMS.environmentId).from((Expression)ENVIRONMENT_SYSTEMS)).where((Predicate)EnvironmentRepositoryImpl.ENVIRONMENT_SYSTEMS.systemId.eq((Object)systemId))).fetch();
        return this.geShortByIds(environmentIds);
    }

    public List<Environment> getByIds(List<UUID> uuids) {
        List result = ((SQLQuery)((SQLQuery)this.queryFactory.select(this.resolveProjection()).from((Expression)ENVIRONMENTS)).where((Predicate)EnvironmentRepositoryImpl.ENVIRONMENTS.id.in(uuids))).fetch();
        return CollectionUtils.isEmpty((Collection)result) ? Collections.emptyList() : result;
    }

    public List<Environment> geShortByIds(List<UUID> uuids) {
        List result = ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.shortProjection).from((Expression)ENVIRONMENTS)).where((Predicate)EnvironmentRepositoryImpl.ENVIRONMENTS.id.in(uuids))).fetch();
        return CollectionUtils.isEmpty((Collection)result) ? Collections.emptyList() : result;
    }

    public UUID getProjectIdBySystemId(@Nonnull UUID systemId) {
        UUID environmentId = (UUID)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)EnvironmentRepositoryImpl.ENVIRONMENT_SYSTEMS.environmentId).from((Expression)ENVIRONMENT_SYSTEMS)).where((Predicate)EnvironmentRepositoryImpl.ENVIRONMENT_SYSTEMS.systemId.eq((Object)systemId))).fetchFirst();
        return this.getProjectIdByEnvironmentId(environmentId);
    }

    public UUID getProjectIdByEnvironmentId(@Nonnull UUID environmentId) {
        return (UUID)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)EnvironmentRepositoryImpl.ENVIRONMENTS.projectId).from((Expression)ENVIRONMENTS)).where((Predicate)EnvironmentRepositoryImpl.ENVIRONMENTS.id.eq((Object)environmentId))).fetchOne();
    }

    public Environment getByNameAndProjectId(String name, UUID projectId) {
        return (Environment)((SQLQuery)((SQLQuery)this.queryFactory.select(this.resolveProjection()).from((Expression)ENVIRONMENTS)).where((Predicate)EnvironmentRepositoryImpl.ENVIRONMENTS.projectId.eq((Object)projectId).and((Predicate)EnvironmentRepositoryImpl.ENVIRONMENTS.name.eq((Object)name)))).fetchFirst();
    }

    public Environment getBySourceIdAndProjectId(UUID sourceId, UUID projectId) {
        return (Environment)((SQLQuery)((SQLQuery)this.queryFactory.select(this.resolveProjection()).from((Expression)ENVIRONMENTS)).where((Predicate)EnvironmentRepositoryImpl.ENVIRONMENTS.projectId.eq((Object)projectId).and((Predicate)EnvironmentRepositoryImpl.ENVIRONMENTS.sourceId.eq((Object)sourceId)))).fetchFirst();
    }

    public List<Environment> findBySearchRequest(BaseSearchRequestDto searchRequest, List<UUID> projectIdsWithAccess) throws Exception {
        Set<String> names;
        SQLQuery sqlQuery = (SQLQuery)this.queryFactory.select(this.resolveProjection()).from((Expression)ENVIRONMENTS);
        ArrayList<BooleanExpression> searchExpressions = new ArrayList<BooleanExpression>();
        UUID projectId = searchRequest.getProjectId();
        if (Objects.nonNull(projectId)) {
            if (CollectionUtils.isEmpty(projectIdsWithAccess) || !projectIdsWithAccess.contains(searchRequest.getProjectId())) {
                return Collections.emptyList();
            }
            sqlQuery = (SQLQuery)sqlQuery.where((Predicate)EnvironmentRepositoryImpl.ENVIRONMENTS.projectId.eq((Object)projectId));
            searchExpressions.add(EnvironmentRepositoryImpl.ENVIRONMENTS.projectId.eq((Object)projectId));
        } else if (!CollectionUtils.isEmpty(projectIdsWithAccess)) {
            sqlQuery = (SQLQuery)sqlQuery.where((Predicate)EnvironmentRepositoryImpl.ENVIRONMENTS.projectId.in(projectIdsWithAccess));
            searchExpressions.add(EnvironmentRepositoryImpl.ENVIRONMENTS.projectId.in(projectIdsWithAccess));
        }
        Set<UUID> ids = searchRequest.getIds();
        if (!CollectionUtils.isEmpty(ids)) {
            sqlQuery = (SQLQuery)sqlQuery.where((Predicate)EnvironmentRepositoryImpl.ENVIRONMENTS.id.in(ids));
            searchExpressions.add(EnvironmentRepositoryImpl.ENVIRONMENTS.id.in(ids));
        }
        if (!CollectionUtils.isEmpty(names = searchRequest.getNames())) {
            BooleanExpression nameContainExpression = names.stream().map(arg_0 -> ((StringPath)EnvironmentRepositoryImpl.ENVIRONMENTS.name).containsIgnoreCase(arg_0)).reduce(BooleanExpression::or).orElseThrow(() -> new IllegalStateException("Failed to construct environment search query: invalid contain name params"));
            sqlQuery = (SQLQuery)sqlQuery.where((Predicate)nameContainExpression);
            searchExpressions.add(nameContainExpression);
        }
        if (!searchExpressions.isEmpty()) {
            sqlQuery.where((Predicate[])searchExpressions.toArray(new BooleanExpression[0]));
            return sqlQuery.fetch();
        }
        return Collections.emptyList();
    }

    @Override
    public Context getContext() {
        return this.contextRepository.getContext();
    }

    @Override
    public MappingProjection<Environment> getFullProjection() {
        return this.projection;
    }

    @Override
    public MappingProjection<Environment> getLazyProjection() {
        return this.lazyProjection;
    }

    @Override
    public MappingProjection<Environment> getShortProjection() {
        return this.shortProjection;
    }

    public List<Environment> getEnvironmentsByFilterPaged(EnvironmentsWithFilterRequest request, Integer size, Integer offset) {
        GenericEnvironmentProjection projection = this.getLazyProjection();
        if (!CollectionUtils.isEmpty(request.getFields())) {
            projection = new GenericEnvironmentProjection(this, request.getFields(), this.environmentMapper);
        }
        SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select(projection).from((Expression)ENVIRONMENTS)).groupBy((Expression)EnvironmentRepositoryImpl.ENVIRONMENTS.id)).orderBy(EnvironmentRepositoryImpl.ENVIRONMENTS.name.asc());
        BooleanExpression whereExpression = EnvironmentRepositoryImpl.ENVIRONMENTS.projectId.eq((Object)request.getProjectId());
        if (!CollectionUtils.isEmpty(request.getFilter())) {
            whereExpression = this.environmentMapper.mapFilter((SQLQuery<Environment>)sqlQuery, whereExpression, request.getFilter());
        }
        sqlQuery = (SQLQuery)sqlQuery.where((Predicate)whereExpression);
        if (size != null && offset != null) {
            sqlQuery = (SQLQuery)((SQLQuery)sqlQuery.offset((long)offset.intValue())).limit((long)size.intValue());
        }
        return sqlQuery.fetch();
    }

    public PGobject createTagsPgObject(List<String> tags) {
        PGobject tagsPgObject = new PGobject();
        tagsPgObject.setType("jsonb");
        try {
            tagsPgObject.setValue(new Gson().toJson(tags == null ? Collections.emptyList() : tags));
        }
        catch (SQLException e) {
            log.error("Error occurred while \"tags\" field processing in Environment", (Throwable)e);
            throw new RuntimeException();
        }
        return tagsPgObject;
    }
}

