/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.repo.impl;

import com.google.common.base.Preconditions;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MappingProjection;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.qubership.atp.environments.model.Environment;
import org.qubership.atp.environments.model.Project;
import org.qubership.atp.environments.model.impl.Context;
import org.qubership.atp.environments.model.utils.Constants;
import org.qubership.atp.environments.repo.impl.AbstractRepository;
import org.qubership.atp.environments.repo.impl.ContextRepository;
import org.qubership.atp.environments.repo.impl.EnvironmentRepositoryImpl;
import org.qubership.atp.environments.repo.impl.ProjectionRepository;
import org.qubership.atp.environments.repo.impl.SystemRepositoryImpl;
import org.qubership.atp.environments.repo.projections.FullProjectProjection;
import org.qubership.atp.environments.repo.projections.LazyProjectProjection;
import org.qubership.atp.environments.repo.projections.ShortProjectProjection;
import org.qubership.atp.environments.service.direct.KafkaService;
import org.qubership.atp.environments.service.rest.server.dto.EventType;
import org.qubership.atp.environments.service.rest.server.request.ProjectSearchRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Repository
public class ProjectRepositoryImpl
extends AbstractRepository
implements ProjectionRepository<Project> {
    private final SQLQueryFactory queryFactory;
    private final Provider<EnvironmentRepositoryImpl> environmentRepo;
    private final Provider<SystemRepositoryImpl> systemRepo;
    private final FullProjectProjection projection = new FullProjectProjection(this);
    private final ShortProjectProjection shortProjectProjection = new ShortProjectProjection(this);
    private final LazyProjectProjection lazyProjection = new LazyProjectProjection(this);
    private final ContextRepository contextRepository;
    private final KafkaService kafkaService;

    @Autowired
    public ProjectRepositoryImpl(SQLQueryFactory queryFactory, Provider<EnvironmentRepositoryImpl> environmentRepo, Provider<SystemRepositoryImpl> systemRepo, ContextRepository repository, KafkaService kafkaService) {
        this.queryFactory = queryFactory;
        this.environmentRepo = environmentRepo;
        this.systemRepo = systemRepo;
        this.contextRepository = repository;
        this.kafkaService = kafkaService;
    }

    public Provider<EnvironmentRepositoryImpl> getEnvironmentRepo() {
        return this.environmentRepo;
    }

    @Nullable
    public Project getById(@Nonnull UUID id) {
        Project project = (Project)((SQLQuery)((SQLQuery)this.queryFactory.select(this.resolveProjection()).from((Expression)PROJECTS)).where((Predicate)ProjectRepositoryImpl.PROJECTS.id.eq((Object)id))).fetchOne();
        Preconditions.checkNotNull((Object)project, (String)"Project %s not found", (Object)id);
        return project;
    }

    @Nullable
    public Project getShortById(@Nonnull UUID id) {
        Project project = (Project)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.shortProjectProjection).from((Expression)PROJECTS)).where((Predicate)ProjectRepositoryImpl.PROJECTS.id.eq((Object)id))).fetchOne();
        Preconditions.checkNotNull((Object)project, (String)"Project %s not found", (Object)id);
        return project;
    }

    @Nullable
    public Project getShortByName(@Nonnull String name) {
        Project project = (Project)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.shortProjectProjection).from((Expression)PROJECTS)).where((Predicate)ProjectRepositoryImpl.PROJECTS.name.eq((Object)name))).fetchOne();
        Preconditions.checkNotNull((Object)project, (String)"Project %s not found", (Object)name);
        return project;
    }

    @Transactional
    public boolean existsById(@Nonnull UUID id) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.shortProjectProjection).from((Expression)PROJECTS)).where((Predicate)ProjectRepositoryImpl.PROJECTS.id.eq((Object)id))).fetchCount() > 0L;
    }

    @Nonnull
    public List<Project> getAll() {
        return ((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select(this.resolveProjection()).from((Expression)PROJECTS)).where((Predicate)ProjectRepositoryImpl.PROJECTS.id.ne((Object)Constants.Project.DEFAULT))).orderBy(ProjectRepositoryImpl.PROJECTS.name.asc())).fetch();
    }

    @Nonnull
    public List<Project> getAllShort() {
        return ((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.shortProjectProjection).from((Expression)PROJECTS)).where((Predicate)ProjectRepositoryImpl.PROJECTS.id.ne((Object)Constants.Project.DEFAULT))).orderBy(ProjectRepositoryImpl.PROJECTS.name.asc())).fetch();
    }

    @Nonnull
    public Project create(@Nonnull UUID id, @Nonnull String name, @Nullable String shortName, String description, Long created) {
        Timestamp createdTimestamp = new Timestamp(created);
        ((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)PROJECTS).set((Path)ProjectRepositoryImpl.PROJECTS.name, (Object)name)).set((Path)ProjectRepositoryImpl.PROJECTS.shortName, (Object)name)).set((Path)ProjectRepositoryImpl.PROJECTS.description, (Object)description)).set((Path)ProjectRepositoryImpl.PROJECTS.created, (Object)createdTimestamp)).set((Path)ProjectRepositoryImpl.PROJECTS.id, (Object)id)).execute();
        return this.projection.create(id, name, shortName, description, createdTimestamp, null);
    }

    @Nonnull
    public Project create(@Nonnull String name, @Nullable String shortName, String description, Long created) {
        Timestamp createdTimestamp = new Timestamp(created);
        UUID id = (UUID)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)PROJECTS).set((Path)ProjectRepositoryImpl.PROJECTS.name, (Object)name)).set((Path)ProjectRepositoryImpl.PROJECTS.shortName, (Object)name)).set((Path)ProjectRepositoryImpl.PROJECTS.description, (Object)description)).set((Path)ProjectRepositoryImpl.PROJECTS.created, (Object)createdTimestamp)).executeWithKey((Path)ProjectRepositoryImpl.PROJECTS.id);
        return this.projection.create(id, name, shortName, description, createdTimestamp, null);
    }

    @Nonnull
    public Project update(@Nonnull UUID projectId, @Nonnull String name, @Nullable String shortName, String description, Long modified) {
        Timestamp modifiedTimestamp = new Timestamp(modified);
        long update = ((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)PROJECTS).set((Path)ProjectRepositoryImpl.PROJECTS.name, (Object)name)).set((Path)ProjectRepositoryImpl.PROJECTS.shortName, (Object)name)).set((Path)ProjectRepositoryImpl.PROJECTS.description, (Object)description)).set((Path)ProjectRepositoryImpl.PROJECTS.modified, (Object)modifiedTimestamp)).where((Predicate)ProjectRepositoryImpl.PROJECTS.id.eq((Object)projectId))).execute();
        Preconditions.checkArgument((update > 0L ? 1 : 0) != 0, (Object)"Nothing updated");
        Timestamp created = (Timestamp)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)ProjectRepositoryImpl.PROJECTS.created).from((Expression)PROJECTS)).where((Predicate)ProjectRepositoryImpl.PROJECTS.id.eq((Object)projectId))).fetchOne();
        return this.projection.create(projectId, name, shortName, description, created, modifiedTimestamp);
    }

    @Nonnull
    public Project update(@Nonnull UUID projectId, @Nonnull String name, @Nullable String shortName, Long modified) {
        Timestamp modifiedTimestamp = new Timestamp(modified);
        long update = ((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)PROJECTS).set((Path)ProjectRepositoryImpl.PROJECTS.name, (Object)name)).set((Path)ProjectRepositoryImpl.PROJECTS.shortName, (Object)name)).set((Path)ProjectRepositoryImpl.PROJECTS.modified, (Object)modifiedTimestamp)).where((Predicate)ProjectRepositoryImpl.PROJECTS.id.eq((Object)projectId))).execute();
        Preconditions.checkArgument((update > 0L ? 1 : 0) != 0, (Object)"Nothing updated");
        Timestamp created = (Timestamp)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)ProjectRepositoryImpl.PROJECTS.created).from((Expression)PROJECTS)).where((Predicate)ProjectRepositoryImpl.PROJECTS.id.eq((Object)projectId))).fetchOne();
        return this.projection.create(projectId, name, shortName, created, modifiedTimestamp);
    }

    public void delete(UUID projectId) {
        this.deleteReferenceToTable(projectId, (RelationalPathBase)PROJECTS, (SimplePath<UUID>)ProjectRepositoryImpl.PROJECTS.id);
        this.sendProjectDeleteNotification(projectId);
    }

    private void deleteReferenceToTable(UUID projectId, RelationalPathBase path, SimplePath<UUID> simplePath) {
        ((SQLDeleteClause)this.queryFactory.delete((RelationalPath)path).where((Predicate)simplePath.eq((Object)projectId))).execute();
    }

    private void sendProjectDeleteNotification(UUID projectId) {
        Project project;
        try {
            project = this.getById(projectId);
        }
        catch (NullPointerException e) {
            return;
        }
        if (!CollectionUtils.isEmpty((Collection)project.getEnvironments())) {
            project.getEnvironments().forEach(environment -> {
                this.kafkaService.sendEnvironmentKafkaNotification(environment.getId(), EventType.DELETE, projectId);
                if (!CollectionUtils.isEmpty((Collection)environment.getSystems())) {
                    environment.getSystems().forEach(system -> this.kafkaService.sendSystemKafkaNotification(system.getId(), EventType.DELETE, projectId));
                }
            });
        }
    }

    public List<Project> getByIds(Set<UUID> prjIds) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)PROJECTS)).where((Predicate)ProjectRepositoryImpl.PROJECTS.id.in(prjIds))).fetch();
    }

    public Project getLazyById(UUID id) {
        Project project = (Project)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.shortProjectProjection).from((Expression)PROJECTS)).where((Predicate)ProjectRepositoryImpl.PROJECTS.id.eq((Object)id))).fetchOne();
        Preconditions.checkNotNull((Object)project, (String)"Project %s not found", (Object)id);
        return project;
    }

    @Override
    public Context getContext() {
        return this.contextRepository.getContext();
    }

    @Override
    public MappingProjection<Project> getFullProjection() {
        return this.projection;
    }

    @Override
    public MappingProjection<Project> getLazyProjection() {
        return this.lazyProjection;
    }

    @Override
    public MappingProjection<Project> getShortProjection() {
        return this.shortProjectProjection;
    }

    public List<Project> getProjectsByRequest(ProjectSearchRequest request, List<UUID> projectIdWithAccess) {
        List<UUID> projectIds;
        List<UUID> list = projectIds = CollectionUtils.isEmpty(request.getProjectIds()) ? projectIdWithAccess : request.getProjectIds().stream().filter(projectIdWithAccess::contains).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(projectIds)) {
            return Collections.emptyList();
        }
        BooleanExpression projectPredicate = ProjectRepositoryImpl.PROJECTS.id.in(projectIds);
        List<String> projectNames = request.getProjectNames();
        if (!CollectionUtils.isEmpty(projectNames)) {
            projectPredicate = projectPredicate.and((Predicate)ProjectRepositoryImpl.PROJECTS.name.in(projectNames));
        }
        List projects = ((SQLQuery)((SQLQuery)this.queryFactory.select(this.getShortProjection()).from((Expression)PROJECTS)).where((Predicate)projectPredicate)).fetch();
        for (Project project : projects) {
            this.fillEnvironmentForProject(request, project);
        }
        return projects;
    }

    private void fillEnvironmentForProject(ProjectSearchRequest request, Project project) {
        List<String> environmentNames;
        BooleanExpression environmentPredicate = ProjectRepositoryImpl.ENVIRONMENTS.projectId.in((Object[])new UUID[]{project.getId()});
        List<UUID> environmentIds = request.getEnvironmentIds();
        if (!CollectionUtils.isEmpty(environmentIds)) {
            environmentPredicate = environmentPredicate.and((Predicate)ProjectRepositoryImpl.ENVIRONMENTS.id.in(environmentIds));
        }
        if (!CollectionUtils.isEmpty(environmentNames = request.getEnvironmentNames())) {
            environmentPredicate = environmentPredicate.and((Predicate)ProjectRepositoryImpl.ENVIRONMENTS.name.in(environmentNames));
        }
        List environments = ((SQLQuery)((SQLQuery)this.queryFactory.select(((EnvironmentRepositoryImpl)this.environmentRepo.get()).getShortProjection()).where((Predicate)environmentPredicate)).from((Expression)ENVIRONMENTS)).fetch();
        for (Environment environment : environments) {
            this.fillSystemsForEnvironment(request, environment);
        }
        project.setEnvironments(environments);
    }

    private void fillSystemsForEnvironment(ProjectSearchRequest request, Environment environment) {
        List<String> systemNames;
        BooleanExpression systemPredicate = ProjectRepositoryImpl.ENVIRONMENT_SYSTEMS.environmentId.eq((Object)environment.getId());
        List<UUID> systemIds = request.getSystemIds();
        if (!CollectionUtils.isEmpty(systemIds)) {
            systemPredicate = systemPredicate.and((Predicate)ProjectRepositoryImpl.SYSTEMS.id.in(systemIds));
        }
        if (!CollectionUtils.isEmpty(systemNames = request.getSystemNames())) {
            systemPredicate = systemPredicate.and((Predicate)ProjectRepositoryImpl.SYSTEMS.name.in(systemNames));
        }
        List systems = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select(((SystemRepositoryImpl)this.systemRepo.get()).getFullProjection()).from((Expression)SYSTEMS)).leftJoin((EntityPath)ENVIRONMENT_SYSTEMS)).on((Predicate)ProjectRepositoryImpl.ENVIRONMENT_SYSTEMS.systemId.eq((Expression)ProjectRepositoryImpl.SYSTEMS.id))).where((Predicate)systemPredicate)).fetch();
        environment.setSystems(systems);
    }
}

