/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.repo.projections;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MappingProjection;
import com.querydsl.sql.RelationalPathBase;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.util.List;
import java.util.UUID;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.qubership.atp.environments.errorhandling.request.EnvironmentsWithFilterRequestException;
import org.qubership.atp.environments.model.Environment;
import org.qubership.atp.environments.model.impl.EnvironmentImpl;
import org.qubership.atp.environments.repo.impl.AbstractRepository;
import org.qubership.atp.environments.repo.impl.EnvironmentRepositoryImpl;
import org.qubership.atp.environments.repo.impl.SystemRepositoryImpl;
import org.qubership.atp.environments.repo.mapper.EnvironmentMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED", "SE_BAD_FIELD"})
public class GenericEnvironmentProjection
extends MappingProjection<Environment> {
    private static final Logger log = LoggerFactory.getLogger(GenericEnvironmentProjection.class);
    private static final long serialVersionUID = 42L;
    protected final transient EnvironmentRepositoryImpl repo;
    private final List<String> fields;
    private final EnvironmentMapper environmentMapper;

    public GenericEnvironmentProjection(EnvironmentRepositoryImpl repo, List<String> fields, EnvironmentMapper mapper) {
        super(Environment.class, (Expression[])AbstractRepository.ENVIRONMENTS.all());
        this.repo = repo;
        this.fields = fields;
        this.environmentMapper = mapper;
    }

    protected Environment map(Tuple tuple) {
        EnvironmentImpl environment = new EnvironmentImpl();
        if (CollectionUtils.isEmpty(this.fields)) {
            return new EnvironmentImpl();
        }
        for (String fieldName : this.fields) {
            try {
                if (fieldName.contains("systems")) {
                    UUID environmentId = (UUID)tuple.get((Expression)AbstractRepository.ENVIRONMENTS.id);
                    if (environmentId == null) continue;
                    environment.setSystems(((SystemRepositoryImpl)this.repo.getSystemRepo().get()).getAllByParentId(environmentId));
                    continue;
                }
                Object value = tuple.get(this.environmentMapper.getField(fieldName, (RelationalPathBase<?>)AbstractRepository.ENVIRONMENTS));
                PropertyUtils.setProperty((Object)environment, (String)fieldName, (Object)(value instanceof Timestamp ? Long.valueOf(((Timestamp)value).getTime()) : value));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                String message = String.format("Incorrect field name: %s", fieldName);
                log.error(message, (Throwable)e);
                throw new EnvironmentsWithFilterRequestException(message);
            }
        }
        return environment;
    }
}

