/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.gracefulshutdown;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.GracefulShutdownHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;

public class GracefulUndertowShutdown
implements ApplicationListener<ContextClosedEvent>,
HandlerWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(GracefulUndertowShutdown.class);
    private final int waitTime = 30000;
    private volatile GracefulShutdownHandler handler;

    public HttpHandler wrap(HttpHandler handler) {
        this.handler = new GracefulShutdownHandler(handler);
        return this.handler;
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        try {
            this.handler.shutdown();
            this.handler.awaitShutdown(30000L);
        }
        catch (InterruptedException ex) {
            LOGGER.error(ex.getMessage());
        }
    }
}

