/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.server;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.qubership.atp.environments.model.DatabaseDirectory;
import org.qubership.atp.environments.service.direct.DatabaseDirectoryService;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/database-directory"})
@RestController
public class DatabaseDirectoryController {
    private final DatabaseDirectoryService databaseDirectoryService;

    @Autowired
    public DatabaseDirectoryController(DatabaseDirectoryService databaseDirectoryService) {
        this.databaseDirectoryService = databaseDirectoryService;
    }

    @GetMapping(value={"/{name}"})
    @AuditAction(auditAction="Get database directory by name {{#name}}")
    public ResponseEntity<DatabaseDirectory> getName(@PathVariable(value="name") String name) {
        return Optional.ofNullable(this.databaseDirectoryService.getName(name.toLowerCase(Locale.ENGLISH))).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping
    @AuditAction(auditAction="Get all database directories")
    public List<DatabaseDirectory> getAll() {
        return this.databaseDirectoryService.getAll();
    }
}

