/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.server;

import com.fasterxml.jackson.annotation.JsonView;
import com.google.common.base.Preconditions;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.environments.model.Connection;
import org.qubership.atp.environments.model.Environment;
import org.qubership.atp.environments.model.Project;
import org.qubership.atp.environments.model.System;
import org.qubership.atp.environments.model.impl.ProjectImpl;
import org.qubership.atp.environments.model.utils.Constants;
import org.qubership.atp.environments.model.utils.View;
import org.qubership.atp.environments.service.direct.EnvironmentService;
import org.qubership.atp.environments.service.direct.ProjectService;
import org.qubership.atp.environments.service.direct.SystemService;
import org.qubership.atp.environments.service.rest.server.dto.EnvironmentDto;
import org.qubership.atp.environments.service.rest.server.dto.ProjectDto;
import org.qubership.atp.environments.service.rest.server.dto.StatusDto;
import org.qubership.atp.environments.service.rest.server.request.ProjectSearchRequest;
import org.qubership.atp.environments.service.rest.server.response.GroupedByTagEnvironmentResponse;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api"})
@RestController
public class ProjectController {
    private final ProjectService projectService;
    private final EnvironmentService environmentService;
    private final SystemService systemService;

    @Autowired
    public ProjectController(ProjectService projectService, EnvironmentService environmentService, SystemService systemService) {
        this.projectService = projectService;
        this.environmentService = environmentService;
        this.systemService = systemService;
    }

    @GetMapping(value={"/projects"})
    @JsonView(value={View.FullVer2.class})
    @AuditAction(auditAction="Get all projects")
    public List<Project> getAllProjects(@RequestParam(value="host", required=false) String host) {
        if (StringUtils.isNotBlank((CharSequence)host)) {
            return this.projectService.getProjectsByHost(host);
        }
        return this.projectService.getAll();
    }

    @JsonView(value={View.Name.class})
    @GetMapping(value={"/projects/short"})
    @AuditAction(auditAction="Get all short projects")
    public List<Project> getAllShort() {
        return this.projectService.getAllShort();
    }

    @JsonView(value={View.Name.class})
    @AuditAction(auditAction="Get all short projects with access")
    @GetMapping(value={"/projects/shortWithAccess"})
    @Deprecated
    public List<Project> getAllShortWithUserAccess() {
        return this.projectService.getAllShort();
    }

    @GetMapping(value={"/projects/{projectId}"})
    @JsonView(value={View.FullVer1.class})
    @AuditAction(auditAction="Get project with uuid {{#id.toString()}}")
    public Project getProject(@PathVariable(value="projectId") UUID id) {
        return (Project)this.projectService.get(id);
    }

    @GetMapping(value={"/projects/short/{projectId}"})
    @PreAuthorize(value="@entityAccess.checkAccess(#id,'READ')")
    @JsonView(value={View.FullVer1.class})
    public Project getShortProject(@PathVariable(value="projectId") UUID id) {
        return this.projectService.getShort(id);
    }

    @GetMapping(value={"/projects/short/name/{projectName}"})
    @JsonView(value={View.FullVer1.class})
    public Project getShortProjectByName(@PathVariable(value="projectName") String name) {
        return this.projectService.getShortByName(name);
    }

    @GetMapping(value={"/projects/{projectId}/{environmentIds}"})
    @JsonView(value={View.FullVer1.class})
    @AuditAction(auditAction="Get project with specified environments for project {{#projectId.toString()}}")
    public ResponseEntity<Project> getProjectWithSpecifiedEnvironments(@PathVariable(value="projectId") UUID projectId, @PathVariable(value="environmentIds") List<UUID> environmentIds) {
        Project project = this.projectService.getProjectWithSpecifiedEnvironments(projectId, environmentIds);
        return project != null ? ResponseEntity.ok((Object)project) : ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/projects/{projectId}/environments/systems/short"})
    @JsonView(value={View.Environments.class})
    @Operation(description="Endpoint for getting list of systems on project by projectId")
    @AuditAction(auditAction="Get all short systems by project id {{#id.toString()}}")
    public List<System> getAllShortSystemsOnProject(@PathVariable(value="projectId") @Parameter(description="Project id for getting system") UUID id) {
        return this.projectService.getSystemsByProjectId(id);
    }

    @GetMapping(value={"/projects/{projectId}/environments"})
    @AuditAction(auditAction="Get all environments by project id {{#id.toString()}}")
    public List<Environment> getEnvironments(@PathVariable(value="projectId") UUID id) {
        return this.projectService.getEnvironments(id);
    }

    @GetMapping(value={"/projects/{projectId}/environments/groupedByTags"})
    public Collection<GroupedByTagEnvironmentResponse> getEnvironmentsGroupedByTags(@PathVariable(value="projectId") UUID id) {
        return this.environmentService.getGroupedByTagEnvironments(id);
    }

    @PreAuthorize(value="@entityAccess.isAuthenticated()")
    @PostMapping(value={"/projects/search"})
    @JsonView(value={View.FullVer1.class})
    public List<Project> getProjectsByRequest(@RequestBody ProjectSearchRequest request) {
        return this.projectService.getProjectsByRequest(request);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#projectId,'UPDATE')")
    @PutMapping(value={"projects/{projectId}/systems/status"})
    @JsonView(value={View.FullVer2.class})
    @AuditAction(auditAction="Update system statuses by project id {{#projectId.toString()}} and system statuses list")
    public ResponseEntity<Object> updateSystemStatuses(@RequestBody List<StatusDto> statuses, @PathVariable UUID projectId) {
        return ResponseEntity.ok(this.systemService.saveStatusesAndDateOfLastCheck(statuses, projectId));
    }

    @JsonView(value={View.Name.class})
    @GetMapping(value={"/projects/{projectId}/environments/short"})
    @AuditAction(auditAction="Get short environments by project id {{#id.toString()}}")
    public List<Environment> getEnvironmentsShort(@PathVariable(value="projectId") UUID id) {
        return this.projectService.getShortEnvironments(id);
    }

    @GetMapping(value={"/projects/{projectId}/temporary/environments"})
    @AuditAction(auditAction="Get temporary environments by project id {{#id.toString()}}")
    public List<Environment> getTemporaryEnvironments(@PathVariable(value="projectId") UUID id) {
        return this.projectService.getTemporaryEnvironments(id);
    }

    @GetMapping(value={"/projects/{projectId}/environments/all"})
    @AuditAction(auditAction="Get all environments (including temporary)  by project id {{#id.toString()}}")
    public List<Environment> getAllEnvironments(@PathVariable(value="projectId") UUID id) {
        return this.projectService.getAllEnvironments(id);
    }

    @GetMapping(value={"/projects/{projectId}/tools"})
    @AuditAction(auditAction="Get TA Tools by project id {{#id.toString()}}")
    public List<Environment> getTools(@PathVariable(value="projectId") UUID id) {
        return this.projectService.getTools(id);
    }

    @JsonView(value={View.Name.class})
    @GetMapping(value={"/projects/{projectId}/tools/short"})
    @AuditAction(auditAction="Get short TA Tools by project id {{#id.toString()}}")
    public List<Environment> getToolsShort(@PathVariable(value="projectId") UUID id) {
        return this.projectService.getShortTools(id);
    }

    @JsonView(value={View.FullVer2.class})
    @GetMapping(value={"/projects/{projectId}/environments/systems"})
    @AuditAction(auditAction="Get project systems by project id {{#id.toString()}} and categoryName {{#categoryName}}")
    public List<System> getProjectSystems(@PathVariable(value="projectId") UUID id, @RequestParam(value="category", required=false) String categoryName) {
        if (StringUtils.isNotBlank((CharSequence)categoryName)) {
            return this.projectService.getSystemsByProjectIdAndCategoryName(id, categoryName);
        }
        return this.projectService.getSystemsByProjectId(id);
    }

    @GetMapping(value={"/projects/{projectId}/environments/systems/name"})
    @AuditAction(auditAction="Get system names by project id {{#id.toString()}}")
    public List<String> getSystemsName(@PathVariable(value="projectId") UUID id) {
        return this.projectService.getSystemNames(id);
    }

    @JsonView(value={View.FullVer2.class})
    @GetMapping(value={"/projects/{projectId}/environments/connections"})
    @AuditAction(auditAction="Get connections by project id {{#id.toString()}}")
    public List<Connection> getConnections(@PathVariable(value="projectId") UUID id) {
        return this.projectService.getConnections(id);
    }

    @GetMapping(value={"/projects/{projectId}/environments/connections/name"})
    @AuditAction(auditAction="Get connection names by project id {{#id.toString()}}")
    public List<String> getConnectionsName(@PathVariable(value="projectId") UUID id) {
        return this.projectService.getConnectionNames(id);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#id.toString(),'CREATE')")
    @PostMapping(value={"/projects/{projectId}/environments"})
    @AuditAction(auditAction="Create environment with name {{#environment.name}} by project id {{#id.toString()}}")
    public Environment createEnvironment(@PathVariable(value="projectId") UUID id, @RequestBody EnvironmentDto environment) {
        return this.projectService.create(id, environment, Constants.Environment.Category.ENVIRONMENT);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#id.toString(),'CREATE')")
    @PostMapping(value={"/projects/{projectId}/tools"})
    @AuditAction(auditAction="Create tool with name {{#environment.name}} by project id {{#id.toString()}}}")
    public Environment createTool(@PathVariable(value="projectId") UUID id, @RequestBody EnvironmentDto environment) {
        return this.projectService.create(id, environment, Constants.Environment.Category.TOOL);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#project.getId().toString(),'CREATE')")
    @PostMapping(value={"/projects"})
    @AuditAction(auditAction="Create Project with name {{#project.shortName}}")
    public Project createProject(@RequestBody ProjectImpl project) {
        return this.projectService.create((Project)project);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#project.getId().toString(),'CREATE')")
    @PostMapping(value={"/projects/{projectId}/copy"})
    @AuditAction(auditAction="Copy {{#project.shortName}} with id {{#id.toString()}}")
    public Project copy(@PathVariable(value="projectId") UUID id, @RequestBody ProjectDto project) {
        return this.projectService.copy(id, project.getName(), project.getShortName(), project.getDescription());
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#project.getId().toString(),'UPDATE')")
    @PutMapping(value={"/projects"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @AuditAction(auditAction="Update Project {{#project.id}}.")
    public void updateProject(@RequestBody ProjectDto project) {
        Preconditions.checkNotNull((Object)project.getId(), (Object)"Project id can't be empty");
        Preconditions.checkNotNull((Object)project.getName(), (Object)"Project name can't be empty");
        Preconditions.checkNotNull((Object)project.getShortName(), (Object)"Project short name can't be empty");
        this.projectService.update(project.getId(), project.getName(), project.getShortName(), project.getDescription());
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#id.toString(),'DELETE')")
    @DeleteMapping(value={"/projects/{projectId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @AuditAction(auditAction="Delete project by id {{#id.toString()}}")
    public void deleteProject(@PathVariable(value="projectId") UUID id) {
        this.projectService.delete(id);
    }
}

