/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.server;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.environments.model.Subscription;
import org.qubership.atp.environments.service.direct.SubscriptionService;
import org.qubership.atp.environments.service.rest.server.dto.SubscriptionDto;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/subscriptions"})
@RestController
public class SubscriptionController {
    private final SubscriptionService subscriptionService;

    @Autowired
    public SubscriptionController(SubscriptionService service) {
        this.subscriptionService = service;
    }

    @GetMapping(value={"/{subscriptionId}"})
    @AuditAction(auditAction="Get subscription by subscription id {{#uuid.toString()}}")
    public Subscription getSubscription(@PathVariable(value="subscriptionId") UUID uuid) {
        return (Subscription)this.subscriptionService.get(uuid);
    }

    @PostMapping
    @AuditAction(auditAction="Create subscription for project {{#subscription.projectId.toString()}} with subscriber id {{#subscription.subscriberId.toString()}}")
    public Subscription create(@RequestBody SubscriptionDto subscription) {
        Preconditions.checkArgument((boolean)(subscription.getProjectId() != null ^ subscription.getEnvironmentId() != null ^ subscription.getSystemId() != null), (Object)"Only one value must be set: projectId | environmentId | systemId");
        List<UUID> listSubscriptionId = this.subscriptionService.getListSubscriptionsByConditions(subscription.getProjectId(), subscription.getEnvironmentId(), subscription.getSystemId(), subscription.getSubscriberId());
        String messageCheck = "";
        if (!listSubscriptionId.isEmpty()) {
            messageCheck = listSubscriptionId.get(0).toString();
        }
        Preconditions.checkArgument((boolean)listSubscriptionId.isEmpty(), (Object)("This combination (projectId, environmentId, systemId, subscriberId) already exists (subscriptionId: " + messageCheck + ")"));
        return this.subscriptionService.create(subscription.getSubscriptionType(), subscription.getProjectId(), subscription.getEnvironmentId(), subscription.getSystemId(), subscription.getSubscriberId(), subscription.getStatus(), subscription.getLastUpdated());
    }

    @PutMapping
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @AuditAction(auditAction="Update subscription for project {{#subscription.projectId.toString()}} with subscriber id {{#subscription.subscriberId.toString()}}")
    public void update(@RequestBody SubscriptionDto subscription) {
        Preconditions.checkNotNull((Object)subscription.getId(), (Object)"Subscription id can't be empty");
        Preconditions.checkArgument((boolean)(subscription.getProjectId() != null ^ subscription.getEnvironmentId() != null ^ subscription.getSystemId() != null), (Object)"Only one value must be set: projectId | environmentId | systemId");
        this.subscriptionService.update(subscription.getId(), subscription.getSubscriptionType(), subscription.getProjectId(), subscription.getEnvironmentId(), subscription.getSystemId(), subscription.getSubscriberId(), subscription.getStatus(), subscription.getLastUpdated());
    }

    @GetMapping
    @AuditAction(auditAction="Get all subscription")
    public List<Subscription> getAll() {
        return this.subscriptionService.getAll();
    }

    @GetMapping(value={"subscriber/{subscriberId}"})
    @AuditAction(auditAction="Get subscriber {{#subscriberId.toString()}} subscriptions")
    public List<Subscription> getSubscriberSubscriptions(@PathVariable(value="subscriberId") UUID uuid) {
        return this.subscriptionService.getSubscriberSubscriptions(uuid);
    }

    @GetMapping(value={"project/{projectId}"})
    @AuditAction(auditAction="Get subscriptions by project id")
    public List<Subscription> getProjectSubscriptions(@PathVariable(value="projectId") UUID uuid) {
        return this.subscriptionService.getProjectSubscriptions(uuid);
    }

    @GetMapping(value={"environment/{environmentId}"})
    @AuditAction(auditAction="Get subscriptions by environment id: {{#uuid.toString()}}")
    public List<Subscription> getEnvironmentSubscriptions(@PathVariable(value="environmentId") UUID uuid) {
        return this.subscriptionService.getEnvironmentSubscriptions(uuid);
    }

    @GetMapping(value={"system/{systemId}"})
    @AuditAction(auditAction="Get system subscriptions for system id {{#uuid.toString()}}")
    public List<Subscription> getSystemSubscriptions(@PathVariable(value="systemId") UUID uuid) {
        return this.subscriptionService.getSystemSubscriptions(uuid);
    }

    @DeleteMapping(value={"/{subscriptionId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @AuditAction(auditAction="Delete subscription with id {{#subscriptionId.toString()}}")
    public void delete(@PathVariable(value="subscriptionId") UUID subscriptionId) {
        this.subscriptionService.delete(subscriptionId);
    }
}

