/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.server;

import java.util.List;
import org.qubership.atp.environments.enums.TaEngineTypeEnum;
import org.qubership.atp.environments.service.direct.TaEngineProviderService;
import org.qubership.atp.environments.service.rest.server.dto.TaEngineTemplate;
import org.qubership.atp.environments.service.rest.server.dto.TaEngineType;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/ta-engine-provider"})
@RestController
public class TaEngineProviderController {
    private final TaEngineProviderService taEngineProviderService;

    @Autowired
    public TaEngineProviderController(TaEngineProviderService taEngineProviderService) {
        this.taEngineProviderService = taEngineProviderService;
    }

    @GetMapping(value={"/engine-type"})
    @AuditAction(auditAction="Get all TA engine type")
    public List<TaEngineType> getAll() {
        return TaEngineTypeEnum.getAll();
    }

    @GetMapping(value={"/template/{engineType}"})
    @AuditAction(auditAction="Get TA engine template by engine type {{#engineType}}")
    public TaEngineTemplate getTemplate(@PathVariable(value="engineType") String engineType) {
        return this.taEngineProviderService.getTemplate(engineType);
    }
}

