/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.server.generated;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.environments.service.rest.server.dto.generated.AlertDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.AlertImplDtoGenerated;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Validated
@Tag(name="AlertController", description="Alert Controller")
public interface AlertControllerApi {
    @Operation(operationId="create", summary="create", tags={"alert-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlertDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/alerts/create"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<AlertDtoGenerated> create(@Parameter(name="AlertImplDtoGenerated", description="") @Valid @RequestBody(required=false) AlertImplDtoGenerated var1);

    @Operation(operationId="delete", summary="delete", tags={"alert-controller"}, responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/alerts/{alertId}"})
    public ResponseEntity<Void> delete(@Parameter(name="alertId", description="alertId", required=true) @PathVariable(value="alertId") UUID var1);

    @Operation(operationId="getAlert", summary="getAlert", tags={"alert-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlertDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/alerts/{alertId}"}, produces={"application/json"})
    public ResponseEntity<AlertDtoGenerated> getAlert(@Parameter(name="alertId", description="alertId", required=true) @PathVariable(value="alertId") UUID var1);

    @Operation(operationId="getAll", summary="getAll", tags={"alert-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlertDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/alerts"}, produces={"application/json"})
    public ResponseEntity<List<AlertDtoGenerated>> getAll();

    @Operation(operationId="update", summary="update", tags={"alert-controller"}, responses={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/alerts/create"}, consumes={"application/json"})
    public ResponseEntity<Void> update(@Parameter(name="AlertImplDtoGenerated", description="") @Valid @RequestBody(required=false) AlertImplDtoGenerated var1);
}

