/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.server.generated;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.environments.service.rest.server.dto.generated.ConnectionFullVer2ViewDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.EnvironmentDtoDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.EnvironmentNameViewDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.EnvironmentResDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.GroupedByTagEnvironmentResponseDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.ProjectDtoDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.ProjectDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.ProjectFullVer1ViewDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.ProjectFullVer2ViewDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.ProjectImplDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.ProjectNameViewDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.ProjectSearchRequestDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.StatusDtoDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.SystemEnvironmentsViewDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.SystemFullVer2ViewDtoGenerated;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="ProjectController", description="Project Controller")
public interface ProjectControllerApi {
    @Operation(operationId="copy", summary="copy", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/projects/{projectId}/copy"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<ProjectDtoGenerated> copy(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="ProjectDtoDtoGenerated", description="") @Valid @RequestBody(required=false) ProjectDtoDtoGenerated var2);

    @Operation(operationId="createEnvironment", summary="createEnvironment", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentResDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/projects/{projectId}/environments"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<EnvironmentResDtoGenerated> createEnvironment(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="EnvironmentDtoDtoGenerated", description="") @Valid @RequestBody(required=false) EnvironmentDtoDtoGenerated var2);

    @Operation(operationId="createProject", summary="create", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/projects"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<ProjectDtoGenerated> createProject(@Parameter(name="ProjectImplDtoGenerated", description="") @Valid @RequestBody(required=false) ProjectImplDtoGenerated var1);

    @Operation(operationId="createTool", summary="createTool", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentResDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/projects/{projectId}/tools"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<EnvironmentResDtoGenerated> createTool(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="EnvironmentDtoDtoGenerated", description="") @Valid @RequestBody(required=false) EnvironmentDtoDtoGenerated var2);

    @Operation(operationId="deleteProject", summary="delete", tags={"project-controller"}, responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/projects/{projectId}"})
    public ResponseEntity<Void> deleteProject(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="getAllEnvironments", summary="getAllEnvironments", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentResDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/{projectId}/environments/all"}, produces={"application/json"})
    public ResponseEntity<List<EnvironmentResDtoGenerated>> getAllEnvironments(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="getAllProjects", summary="getAll", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectFullVer2ViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects"}, produces={"application/json"})
    public ResponseEntity<List<ProjectFullVer2ViewDtoGenerated>> getAllProjects(@Parameter(name="host", description="host") @Valid @RequestParam(value="host", required=false) String var1, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="getAllShort", summary="getAllShort", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectNameViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/short"}, produces={"application/json"})
    public ResponseEntity<List<ProjectNameViewDtoGenerated>> getAllShort(@Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var1);

    @Operation(operationId="getAllShortSystemsOnProject", summary="Endpoint for getting list of systems on project by projectId", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemEnvironmentsViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/{projectId}/environments/systems/short"}, produces={"application/json"})
    public ResponseEntity<List<SystemEnvironmentsViewDtoGenerated>> getAllShortSystemsOnProject(@Parameter(name="projectId", description="Project id for getting system", required=true) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="getAllShortWithUserAccess", summary="getAllShortWithAccess", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectNameViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/shortWithAccess"}, produces={"application/json"})
    public ResponseEntity<List<ProjectNameViewDtoGenerated>> getAllShortWithUserAccess(@Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var1);

    @Operation(operationId="getConnections", summary="getConnections", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ConnectionFullVer2ViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/{projectId}/environments/connections"}, produces={"application/json"})
    public ResponseEntity<List<ConnectionFullVer2ViewDtoGenerated>> getConnections(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="getConnectionsName", summary="getConnectionsName", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/{projectId}/environments/connections/name"}, produces={"application/json"})
    public ResponseEntity<List<String>> getConnectionsName(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="getEnvironments", summary="getEnvironments", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentResDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/{projectId}/environments"}, produces={"application/json"})
    public ResponseEntity<List<EnvironmentResDtoGenerated>> getEnvironments(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="getEnvironmentsGroupedByTags", summary="getEnvironmentsGroupedByTags", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=GroupedByTagEnvironmentResponseDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/{projectId}/environments/groupedByTags"}, produces={"application/json"})
    public ResponseEntity<List<GroupedByTagEnvironmentResponseDtoGenerated>> getEnvironmentsGroupedByTags(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="getEnvironmentsShort", summary="getEnvironmentsShort", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentNameViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/{projectId}/environments/short"}, produces={"application/json"})
    public ResponseEntity<List<EnvironmentNameViewDtoGenerated>> getEnvironmentsShort(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="getProject", summary="getProject", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectFullVer1ViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/{projectId}"}, produces={"application/json"})
    public ResponseEntity<ProjectFullVer1ViewDtoGenerated> getProject(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="getProjectSystems", summary="getSystems", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemFullVer2ViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/{projectId}/environments/systems"}, produces={"application/json"})
    public ResponseEntity<List<SystemFullVer2ViewDtoGenerated>> getProjectSystems(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="category", description="category") @Valid @RequestParam(value="category", required=false) String var2, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var3);

    @Operation(operationId="getProjectWithSpecifiedEnvironments", summary="getProjectWithSpecifiedEnvironments", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectFullVer1ViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/{projectId}/{environmentIds}"}, produces={"application/json"})
    public ResponseEntity<ProjectFullVer1ViewDtoGenerated> getProjectWithSpecifiedEnvironments(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="environmentIds", description="environmentIds", required=true) @PathVariable(value="environmentIds") List<UUID> var2, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var3);

    @Operation(operationId="getProjectsByRequest", summary="getProjectsByRequest", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectFullVer2ViewDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/projects/search"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<ProjectFullVer2ViewDtoGenerated>> getProjectsByRequest(@Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var1, @Parameter(name="ProjectSearchRequestDtoGenerated", description="") @Valid @RequestBody(required=false) ProjectSearchRequestDtoGenerated var2);

    @Operation(operationId="getShortProject", summary="getShortProject", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectFullVer1ViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/short/{projectId}"}, produces={"application/json"})
    public ResponseEntity<ProjectFullVer1ViewDtoGenerated> getShortProject(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="getShortProjectByName", summary="getShortProjectByName", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectFullVer1ViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/short/name/{projectName}"}, produces={"application/json"})
    public ResponseEntity<ProjectFullVer1ViewDtoGenerated> getShortProjectByName(@Parameter(name="projectName", description="projectName", required=true) @PathVariable(value="projectName") String var1, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="getSystemsName", summary="getSystemsName", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/{projectId}/environments/systems/name"}, produces={"application/json"})
    public ResponseEntity<List<String>> getSystemsName(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="getTemporaryEnvironments", summary="getTemporaryEnvironments", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentResDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/{projectId}/temporary/environments"}, produces={"application/json"})
    public ResponseEntity<List<EnvironmentResDtoGenerated>> getTemporaryEnvironments(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="getTools", summary="getTools", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentResDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/{projectId}/tools"}, produces={"application/json"})
    public ResponseEntity<List<EnvironmentResDtoGenerated>> getTools(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="getToolsShort", summary="getToolsShort", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentNameViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/{projectId}/tools/short"}, produces={"application/json"})
    public ResponseEntity<List<EnvironmentNameViewDtoGenerated>> getToolsShort(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="updateProject", summary="update", tags={"project-controller"}, responses={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/projects"}, consumes={"application/json"})
    public ResponseEntity<Void> updateProject(@Parameter(name="ProjectDtoDtoGenerated", description="") @Valid @RequestBody(required=false) ProjectDtoDtoGenerated var1);

    @Operation(operationId="updateSystemStatuses", summary="updateSystemStatuses", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class))}), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/projects/{projectId}/systems/status"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<Object>> updateSystemStatuses(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="StatusDtoDtoGenerated", description="") @Valid @RequestBody(required=false) List<StatusDtoDtoGenerated> var2);
}

