/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.server.generated;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.environments.service.rest.server.dto.generated.SubscriptionDtoDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.SubscriptionDtoGenerated;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Validated
@Tag(name="SubscriptionController", description="Subscription Controller")
public interface SubscriptionControllerApi {
    @Operation(operationId="create", summary="create", tags={"subscription-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SubscriptionDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/subscriptions"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<SubscriptionDtoGenerated> create(@Parameter(name="SubscriptionDtoDtoGenerated", description="") @Valid @RequestBody(required=false) SubscriptionDtoDtoGenerated var1);

    @Operation(operationId="delete", summary="delete", tags={"subscription-controller"}, responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/subscriptions/{subscriptionId}"})
    public ResponseEntity<Void> delete(@Parameter(name="subscriptionId", description="subscriptionId", required=true) @PathVariable(value="subscriptionId") UUID var1);

    @Operation(operationId="getAll", summary="getAll", tags={"subscription-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SubscriptionDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/subscriptions"}, produces={"application/json"})
    public ResponseEntity<List<SubscriptionDtoGenerated>> getAll();

    @Operation(operationId="getEnvironmentSubscriptions", summary="getEnvironmentSubscriptions", tags={"subscription-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SubscriptionDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/subscriptions/environment/{environmentId}"}, produces={"application/json"})
    public ResponseEntity<List<SubscriptionDtoGenerated>> getEnvironmentSubscriptions(@Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") UUID var1);

    @Operation(operationId="getProjectSubscriptions", summary="getProjectSubscriptions", tags={"subscription-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SubscriptionDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/subscriptions/project/{projectId}"}, produces={"application/json"})
    public ResponseEntity<List<SubscriptionDtoGenerated>> getProjectSubscriptions(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="getSubscriberSubscriptions", summary="getSubscriberSubscriptions", tags={"subscription-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SubscriptionDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/subscriptions/subscriber/{subscriberId}"}, produces={"application/json"})
    public ResponseEntity<List<SubscriptionDtoGenerated>> getSubscriberSubscriptions(@Parameter(name="subscriberId", description="subscriberId", required=true) @PathVariable(value="subscriberId") UUID var1);

    @Operation(operationId="getSubscription", summary="getSubscription", tags={"subscription-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SubscriptionDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/subscriptions/{subscriptionId}"}, produces={"application/json"})
    public ResponseEntity<SubscriptionDtoGenerated> getSubscription(@Parameter(name="subscriptionId", description="subscriptionId", required=true) @PathVariable(value="subscriptionId") UUID var1);

    @Operation(operationId="getSystemSubscriptions", summary="getSystemSubscriptions", tags={"subscription-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SubscriptionDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/subscriptions/system/{systemId}"}, produces={"application/json"})
    public ResponseEntity<List<SubscriptionDtoGenerated>> getSystemSubscriptions(@Parameter(name="systemId", description="systemId", required=true) @PathVariable(value="systemId") UUID var1);

    @Operation(operationId="update", summary="update", tags={"subscription-controller"}, responses={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/subscriptions"}, consumes={"application/json"})
    public ResponseEntity<Void> update(@Parameter(name="SubscriptionDtoDtoGenerated", description="") @Valid @RequestBody(required=false) SubscriptionDtoDtoGenerated var1);
}

