/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.server.generated;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.environments.service.rest.server.dto.generated.EnvironmentDtoDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.EnvironmentDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.SystemDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.SystemFullVer1ViewDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.SystemFullVer2ViewDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.ValidateTaToolsRequestDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.ValidateTaToolsResponseDtoGenerated;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="ToolController", description="Tool Controller")
public interface ToolControllerApi {
    @Operation(operationId="copyTool", summary="copy", tags={"tool-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tools/{toolGroupId}/copy"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<EnvironmentDtoGenerated> copyTool(@Parameter(name="toolGroupId", description="toolGroupId", required=true) @PathVariable(value="toolGroupId") UUID var1, @Parameter(name="EnvironmentDtoDtoGenerated", description="") @Valid @RequestBody(required=false) EnvironmentDtoDtoGenerated var2);

    @Operation(operationId="createTool", summary="create", tags={"tool-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tools"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<EnvironmentDtoGenerated> createTool(@Parameter(name="EnvironmentDtoDtoGenerated", description="") @Valid @RequestBody(required=false) EnvironmentDtoDtoGenerated var1);

    @Operation(operationId="deleteTool", summary="delete", tags={"tool-controller"}, responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/tools/{toolGroupId}"})
    public ResponseEntity<Void> deleteTool(@Parameter(name="toolGroupId", description="toolGroupId", required=true) @PathVariable(value="toolGroupId") UUID var1);

    @Operation(operationId="getAll", summary="getAll", tags={"tool-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tools"}, produces={"application/json"})
    public ResponseEntity<List<EnvironmentDtoGenerated>> getAll(@Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var1);

    @Operation(operationId="getEnvironment", summary="getEnvironment", tags={"tool-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tools/{toolGroupId}"}, produces={"application/json"})
    public ResponseEntity<EnvironmentDtoGenerated> getEnvironment(@Parameter(name="toolGroupId", description="toolGroupId", required=true) @PathVariable(value="toolGroupId") UUID var1, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="getSystemV2", summary="getSystemV2", tags={"tool-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemFullVer2ViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v2/tools/{toolGroupId}/systems"}, produces={"application/json"})
    public ResponseEntity<List<SystemFullVer2ViewDtoGenerated>> getSystemV2(@Parameter(name="toolGroupId", description="toolGroupId", required=true) @PathVariable(value="toolGroupId") UUID var1, @Parameter(name="system_type", description="system_type") @Valid @RequestParam(value="system_type", required=false) String var2, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var3);

    @Operation(operationId="getToolSystems", summary="getSystems", tags={"tool-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemFullVer1ViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tools/{toolGroupId}/systems"}, produces={"application/json"})
    public ResponseEntity<List<SystemFullVer1ViewDtoGenerated>> getToolSystems(@Parameter(name="toolGroupId", description="toolGroupId", required=true) @PathVariable(value="toolGroupId") UUID var1, @Parameter(name="system_type", description="system_type") @Valid @RequestParam(value="system_type", required=false) String var2, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var3);

    @Operation(operationId="updateTool", summary="update", tags={"tool-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/tools"}, consumes={"application/json"})
    public ResponseEntity<Void> updateTool(@Parameter(name="EnvironmentDtoDtoGenerated", description="") @Valid @RequestBody(required=false) EnvironmentDtoDtoGenerated var1);

    @Operation(operationId="updateVersion", summary="updateVersion", tags={"tool-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/tools/{toolGroupId}/version"}, produces={"application/json"})
    public ResponseEntity<List<SystemDtoGenerated>> updateVersion(@Parameter(name="toolGroupId", description="toolGroupId", required=true) @PathVariable(value="toolGroupId") UUID var1);

    @Operation(operationId="validateTaTools", summary="validateTaTools", tags={"tool-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ValidateTaToolsResponseDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/tools/validate"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<ValidateTaToolsResponseDtoGenerated> validateTaTools(@Parameter(name="ValidateTaToolsRequestDtoGenerated", description="") @Valid @RequestBody(required=false) ValidateTaToolsRequestDtoGenerated var1);
}

