/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.utils.cloud;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.environments.errorhandling.clients.EnvironmentCloudClientCreationException;
import org.qubership.atp.environments.model.ConnectionParameters;
import org.qubership.atp.environments.model.System;
import org.qubership.atp.environments.service.rest.server.response.ShortExternalService;
import org.qubership.atp.environments.utils.cloud.KubeClient;
import org.qubership.atp.environments.utils.cloud.model.CloudService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExternalCloudClient {
    protected String serverUrl;
    protected String namespace;
    private static final Logger log = LoggerFactory.getLogger(KubeClient.class);

    public abstract List<ShortExternalService> getShortServices();

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    public static ExternalCloudClient createClient(ConnectionParameters connectionParameters, Class<? extends ExternalCloudClient> clientClass) {
        ExternalCloudClient client;
        try {
            client = clientClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            client.configure(connectionParameters);
        }
        catch (Exception e) {
            String clientClassName = clientClass.getName();
            log.error("Failed to create cloud client for class: {}", (Object)clientClassName);
            throw new EnvironmentCloudClientCreationException(clientClassName);
        }
        return client;
    }

    public abstract List<CloudService> getServicesByServiceId(List<UUID> var1);

    public abstract List<CloudService> getServicesByExistingServices(List<System> var1);

    public abstract void configure(ConnectionParameters var1);
}

