/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.version.checkers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.environments.errorhandling.clients.EnvironmentOpenshiftImageListFetchException;
import org.qubership.atp.environments.model.Connection;
import org.qubership.atp.environments.model.ConnectionParameters;
import org.qubership.atp.environments.utils.cloud.ExternalCloudClient;
import org.qubership.atp.environments.utils.cloud.OpenshiftClient;
import org.qubership.atp.environments.version.checkers.VersionChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenshiftVersionChecker
implements VersionChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenshiftVersionChecker.class);
    private final HashMap<UUID, ConnectionParameters> connectionParametersMap = new HashMap();

    @Override
    public String getVersion() {
        HashSet set = new HashSet();
        this.connectionParametersMap.forEach((connectionId, parameters) -> {
            OpenshiftClient openshiftClient = (OpenshiftClient)ExternalCloudClient.createClient(parameters, OpenshiftClient.class);
            try {
                set.addAll(new HashSet<String>(openshiftClient.getImageSet()));
            }
            catch (Exception e) {
                LOGGER.error("Failed to get image list for project {} from openshift client", (Object)"project", (Object)e);
                String projectName = (String)parameters.get((Object)"project");
                throw new EnvironmentOpenshiftImageListFetchException(projectName);
            }
        });
        ArrayList sortedList = new ArrayList(set);
        Collections.sort(sortedList);
        return sortedList.stream().collect(Collectors.joining("\n", "", ""));
    }

    @Override
    public void setConnectionParameters(Connection parameters) {
        this.connectionParametersMap.put(parameters.getId(), parameters.getParameters());
    }

    @Override
    public void setParametersVersionCheck(String parameters) {
    }

    public static interface OpenShiftCredentialsNames {
        public static final String HOST = "url";
        public static final String LOGIN = "login";
        public static final String PASSWORD = "password";
        public static final String NAMESPACE = "project";
        public static final String TOKEN = "token";
    }
}

