/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.versioning.service.impl;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.javers.core.Javers;
import org.javers.repository.jql.JqlQuery;
import org.javers.repository.jql.QueryBuilder;
import org.javers.shadow.Shadow;
import org.qubership.atp.environments.errorhandling.history.EnvironmentHistoryRevisionNotFoundException;
import org.qubership.atp.environments.mapper.AbstractMapper;
import org.qubership.atp.environments.service.rest.server.dto.generated.CompareEntityResponseDtoGenerated;
import org.qubership.atp.environments.versioning.model.mapper.DateAuditorEntityVersioning;
import org.qubership.atp.environments.versioning.service.VersionHistoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVersionHistoryService<D extends DateAuditorEntityVersioning, S>
implements VersionHistoryService<D, S> {
    private static final Logger log = LoggerFactory.getLogger(AbstractVersionHistoryService.class);
    private AbstractMapper<S, D> abstractMapper;
    private Javers javers;

    public AbstractVersionHistoryService(AbstractMapper<S, D> abstractMapper, Javers javers) {
        this.abstractMapper = abstractMapper;
        this.javers = javers;
    }

    @Override
    public List<CompareEntityResponseDtoGenerated> getEntitiesByVersion(UUID id, List<String> versions) {
        log.debug("id={}, versions={}", (Object)id, versions);
        return versions.stream().map(version -> this.getEntityByRevision(id, (String)version)).collect(Collectors.toList());
    }

    private CompareEntityResponseDtoGenerated getEntityByRevision(UUID id, String version) {
        JqlQuery query = QueryBuilder.byInstanceId((Object)id, this.getEntityClass()).withNewObjectChanges().withVersion(Long.parseLong(version)).build();
        List shadows = this.javers.findShadows(query);
        log.debug("Shadows found : {}", (Object)shadows);
        Optional<Shadow<Object>> entity = shadows.stream().findFirst();
        if (entity.isPresent()) {
            return this.createCompareEntityResponse(version, entity);
        }
        log.error("Failed to find history revision");
        throw new EnvironmentHistoryRevisionNotFoundException();
    }

    protected CompareEntityResponseDtoGenerated createCompareEntityResponse(String version, Optional<Shadow<Object>> entity) {
        log.debug("version={}, entity={}", (Object)version, entity);
        CompareEntityResponseDtoGenerated compareEntityResponseDto = new CompareEntityResponseDtoGenerated();
        compareEntityResponseDto.setRevision(version);
        Shadow<Object> objectShadow = entity.get();
        D resolvedEntity = this.mapToResolvedEntity(objectShadow.get());
        ((DateAuditorEntityVersioning)resolvedEntity).setModifiedBy(objectShadow.getCommitMetadata().getAuthor());
        compareEntityResponseDto.setCompareEntity(resolvedEntity);
        log.debug("compareEntityResponseDto={}", (Object)compareEntityResponseDto);
        return compareEntityResponseDto;
    }

    protected D mapToResolvedEntity(S entityJ) {
        return (D)((DateAuditorEntityVersioning)this.abstractMapper.map(entityJ));
    }
}

