/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.code;

import java.lang.reflect.Method;
import java.util.List;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.code.RandomValueAuthorizationCodeServices;
import org.springframework.security.oauth2.provider.token.store.redis.JdkSerializationStrategy;
import org.springframework.security.oauth2.provider.token.store.redis.RedisTokenStoreSerializationStrategy;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

@Deprecated
public class RedisAuthorizationCodeServices
extends RandomValueAuthorizationCodeServices {
    private static final boolean springDataRedis_2_0 = ClassUtils.isPresent((String)"org.springframework.data.redis.connection.RedisStandaloneConfiguration", (ClassLoader)RedisAuthorizationCodeServices.class.getClassLoader());
    private static final String AUTH_CODE = "auth_code:";
    private final RedisConnectionFactory connectionFactory;
    private String prefix = "";
    private RedisTokenStoreSerializationStrategy serializationStrategy = new JdkSerializationStrategy();
    private Method redisConnectionSet_2_0;

    public RedisAuthorizationCodeServices(RedisConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        if (springDataRedis_2_0) {
            this.loadRedisConnectionMethods_2_0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void store(String code, OAuth2Authentication authentication) {
        block6: {
            byte[] key = this.serializeKey(AUTH_CODE + code);
            byte[] auth = this.serialize((Object)authentication);
            RedisConnection conn = this.getConnection();
            try {
                if (springDataRedis_2_0) {
                    try {
                        this.redisConnectionSet_2_0.invoke((Object)conn, key, auth);
                        break block6;
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
                conn.set(key, auth);
            }
            finally {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OAuth2Authentication remove(String code) {
        byte[] key = this.serializeKey(AUTH_CODE + code);
        List results = null;
        RedisConnection conn = this.getConnection();
        try {
            conn.openPipeline();
            conn.get(key);
            conn.del((byte[][])new byte[][]{key});
            results = conn.closePipeline();
        }
        finally {
            conn.close();
        }
        if (results == null) {
            return null;
        }
        byte[] bytes = (byte[])results.get(0);
        return this.deserializeAuthentication(bytes);
    }

    private void loadRedisConnectionMethods_2_0() {
        this.redisConnectionSet_2_0 = ReflectionUtils.findMethod(RedisConnection.class, (String)"set", (Class[])new Class[]{byte[].class, byte[].class});
    }

    private byte[] serializeKey(String object) {
        return this.serialize(this.prefix + object);
    }

    private byte[] serialize(Object object) {
        return this.serializationStrategy.serialize(object);
    }

    private byte[] serialize(String string) {
        return this.serializationStrategy.serialize(string);
    }

    private RedisConnection getConnection() {
        return this.connectionFactory.getConnection();
    }

    private OAuth2Authentication deserializeAuthentication(byte[] bytes) {
        return this.serializationStrategy.deserialize(bytes, OAuth2Authentication.class);
    }

    public void setSerializationStrategy(RedisTokenStoreSerializationStrategy serializationStrategy) {
        this.serializationStrategy = serializationStrategy;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

