/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.util.HashSet;
import java.util.Set;
import oracle.ons.NodeAddress;
import oracle.ons.NotificationNetwork;
import oracle.ons.ONSConfiguration;
import oracle.ons.ONSConnection;

public class ONSNodeList {
    private ONSConfiguration.NodeList baseNodeList;

    ONSNodeList(ONSConfiguration.NodeList nodeList) {
        this.baseNodeList = nodeList;
    }

    public String getId() {
        return this.baseNodeList.publicId;
    }

    public boolean isActive() {
        return this.baseNodeList.active;
    }

    public int getConcurrency() {
        return this.baseNodeList.maxConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ONSNodeList getFailOver() {
        NotificationNetwork network;
        ONSNodeList failOver = null;
        NotificationNetwork notificationNetwork = network = this.baseNodeList.config.getNetwork();
        synchronized (notificationNetwork) {
            if (this.baseNodeList.failedTo != null) {
                failOver = new ONSNodeList(this.baseNodeList.failedTo);
            } else if (this.baseNodeList.failedFrom != null) {
                failOver = new ONSNodeList(this.baseNodeList.failedFrom);
            }
        }
        return failOver;
    }

    public Set<ONSConnection> getConnections() {
        NotificationNetwork network = this.baseNodeList.config.getNetwork();
        HashSet<ONSConnection> connections = new HashSet<ONSConnection>();
        HashSet<NodeAddress> localAddressList = new HashSet<NodeAddress>();
        network.scanExpandNodeList(this.baseNodeList.addresses, localAddressList);
        for (NodeAddress addr : localAddressList) {
            connections.add(new ONSConnection(addr, this.baseNodeList));
        }
        return connections;
    }
}

