/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.cassandra;

import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.api.core.tracker.RequestTracker;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.docs.AssertingSpan;
import org.springframework.cloud.sleuth.docs.DocumentedSpan;
import org.springframework.cloud.sleuth.docs.EventValue;
import org.springframework.cloud.sleuth.instrument.cassandra.CassandraSpanSupplier;
import org.springframework.cloud.sleuth.instrument.cassandra.SleuthCassandraSpan;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

enum TraceRequestTracker implements RequestTracker
{
    INSTANCE;

    private static final Log log;

    public void onSuccess(@NonNull Request request, long latencyNanos, @NonNull DriverExecutionProfile executionProfile, @NonNull Node node, @NonNull String requestLogPrefix) {
        if (request instanceof CassandraSpanSupplier) {
            Span span = ((CassandraSpanSupplier)request).getSpan();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Closing span [" + span + "]"));
            }
            span.end();
        }
    }

    public void onError(@NonNull Request request, @NonNull Throwable error, long latencyNanos, @NonNull DriverExecutionProfile executionProfile, @Nullable Node node, @NonNull String requestLogPrefix) {
        if (request instanceof CassandraSpanSupplier) {
            Span span = ((CassandraSpanSupplier)request).getSpan();
            span.error(error);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Closing span [" + span + "]"));
            }
            span.end();
        }
    }

    public void onNodeError(@NonNull Request request, @NonNull Throwable error, long latencyNanos, @NonNull DriverExecutionProfile executionProfile, @NonNull Node node, @NonNull String requestLogPrefix) {
        if (request instanceof CassandraSpanSupplier) {
            AssertingSpan span = AssertingSpan.of((DocumentedSpan)SleuthCassandraSpan.CASSANDRA_SPAN, (Span)((CassandraSpanSupplier)request).getSpan());
            span.event((EventValue)SleuthCassandraSpan.Events.NODE_ERROR);
            span.tag(String.format(SleuthCassandraSpan.Tags.NODE_ERROR_TAG.getKey(), node.getEndPoint()), error.toString());
            this.tryAddingRemoteIpAndPort(node, (Span)span);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Marking node error for [" + span + "]"));
            }
        }
    }

    public void onNodeSuccess(@NonNull Request request, long latencyNanos, @NonNull DriverExecutionProfile executionProfile, @NonNull Node node, @NonNull String requestLogPrefix) {
        if (request instanceof CassandraSpanSupplier) {
            AssertingSpan span = AssertingSpan.of((DocumentedSpan)SleuthCassandraSpan.CASSANDRA_SPAN, (Span)((CassandraSpanSupplier)request).getSpan());
            span.event((EventValue)SleuthCassandraSpan.Events.NODE_SUCCESS);
            this.tryAddingRemoteIpAndPort(node, (Span)span);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Marking node success for [" + span + "]"));
            }
        }
    }

    public void onSessionReady(@NonNull Session session) {
    }

    public void close() throws Exception {
    }

    private void tryAddingRemoteIpAndPort(Node node, Span span) {
        try {
            int port;
            String host;
            SocketAddress socketAddress = node.getEndPoint().resolve();
            if (socketAddress instanceof InetSocketAddress) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
                host = inetSocketAddress.getHostString();
                port = inetSocketAddress.getPort();
            } else {
                host = socketAddress.toString();
                port = 0;
            }
            span.remoteIpAndPort(host, port);
        }
        catch (Exception e) {
            log.debug((Object)"Exception occurred while trying to set ip and port", (Throwable)e);
        }
    }

    static {
        log = LogFactory.getLog(TraceRequestTracker.class);
    }
}

