package org.qubership.atp.environments.clients.api.catalogue.generated;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.environments.clients.api.catalogue.generated.ActionParameterDto;
import org.qubership.atp.environments.clients.api.catalogue.generated.MetaInfoTypeDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * MetaInfoDto
 */

@JsonTypeName("MetaInfo")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-04T17:33:37.690364427Z[Etc/UTC]")
public class MetaInfoDto {

  @JsonProperty("otherTextValue")
  private String otherTextValue;

  @JsonProperty("parameters")
  @Valid
  private List<ActionParameterDto> parameters = null;

  @JsonProperty("stepId")
  private UUID stepId;

  @JsonProperty("type")
  private MetaInfoTypeDto type;

  public MetaInfoDto otherTextValue(String otherTextValue) {
    this.otherTextValue = otherTextValue;
    return this;
  }

  /**
   * Get otherTextValue
   * @return otherTextValue
  */
  
  @Schema(name = "otherTextValue", required = false)
  public String getOtherTextValue() {
    return otherTextValue;
  }

  public void setOtherTextValue(String otherTextValue) {
    this.otherTextValue = otherTextValue;
  }

  public MetaInfoDto parameters(List<ActionParameterDto> parameters) {
    this.parameters = parameters;
    return this;
  }

  public MetaInfoDto addParametersItem(ActionParameterDto parametersItem) {
    if (this.parameters == null) {
      this.parameters = new ArrayList<>();
    }
    this.parameters.add(parametersItem);
    return this;
  }

  /**
   * Get parameters
   * @return parameters
  */
  @Valid 
  @Schema(name = "parameters", required = false)
  public List<ActionParameterDto> getParameters() {
    return parameters;
  }

  public void setParameters(List<ActionParameterDto> parameters) {
    this.parameters = parameters;
  }

  public MetaInfoDto stepId(UUID stepId) {
    this.stepId = stepId;
    return this;
  }

  /**
   * Get stepId
   * @return stepId
  */
  @Valid 
  @Schema(name = "stepId", required = false)
  public UUID getStepId() {
    return stepId;
  }

  public void setStepId(UUID stepId) {
    this.stepId = stepId;
  }

  public MetaInfoDto type(MetaInfoTypeDto type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  @Valid 
  @Schema(name = "type", required = false)
  public MetaInfoTypeDto getType() {
    return type;
  }

  public void setType(MetaInfoTypeDto type) {
    this.type = type;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MetaInfoDto metaInfo = (MetaInfoDto) o;
    return Objects.equals(this.otherTextValue, metaInfo.otherTextValue) &&
        Objects.equals(this.parameters, metaInfo.parameters) &&
        Objects.equals(this.stepId, metaInfo.stepId) &&
        Objects.equals(this.type, metaInfo.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(otherTextValue, parameters, stepId, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MetaInfoDto {\n");
    sb.append("    otherTextValue: ").append(toIndentedString(otherTextValue)).append("\n");
    sb.append("    parameters: ").append(toIndentedString(parameters)).append("\n");
    sb.append("    stepId: ").append(toIndentedString(stepId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

