package org.qubership.atp.environments.clients.api.healthcheck.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.environments.clients.api.healthcheck.dto.ProcessStatusDto;
import org.qubership.atp.environments.clients.api.healthcheck.dto.StatusDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ConnectionStatusDto
 */

@JsonTypeName("ConnectionStatus")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-04T17:33:37.573624611Z[Etc/UTC]")
public class ConnectionStatusDto {

  @JsonProperty("connectionId")
  private String connectionId;

  @JsonProperty("name")
  private String name;

  @JsonProperty("host")
  private String host;

  @JsonProperty("status")
  private StatusDto status;

  @JsonProperty("processStatuses")
  @Valid
  private List<ProcessStatusDto> processStatuses = null;

  @JsonProperty("configurationStatuses")
  @Valid
  private List<ProcessStatusDto> configurationStatuses = null;

  public ConnectionStatusDto connectionId(String connectionId) {
    this.connectionId = connectionId;
    return this;
  }

  /**
   * Get connectionId
   * @return connectionId
  */
  
  @Schema(name = "connectionId", required = false)
  public String getConnectionId() {
    return connectionId;
  }

  public void setConnectionId(String connectionId) {
    this.connectionId = connectionId;
  }

  public ConnectionStatusDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ConnectionStatusDto host(String host) {
    this.host = host;
    return this;
  }

  /**
   * Get host
   * @return host
  */
  
  @Schema(name = "host", required = false)
  public String getHost() {
    return host;
  }

  public void setHost(String host) {
    this.host = host;
  }

  public ConnectionStatusDto status(StatusDto status) {
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
  */
  @Valid 
  @Schema(name = "status", required = false)
  public StatusDto getStatus() {
    return status;
  }

  public void setStatus(StatusDto status) {
    this.status = status;
  }

  public ConnectionStatusDto processStatuses(List<ProcessStatusDto> processStatuses) {
    this.processStatuses = processStatuses;
    return this;
  }

  public ConnectionStatusDto addProcessStatusesItem(ProcessStatusDto processStatusesItem) {
    if (this.processStatuses == null) {
      this.processStatuses = new ArrayList<>();
    }
    this.processStatuses.add(processStatusesItem);
    return this;
  }

  /**
   * Get processStatuses
   * @return processStatuses
  */
  @Valid 
  @Schema(name = "processStatuses", required = false)
  public List<ProcessStatusDto> getProcessStatuses() {
    return processStatuses;
  }

  public void setProcessStatuses(List<ProcessStatusDto> processStatuses) {
    this.processStatuses = processStatuses;
  }

  public ConnectionStatusDto configurationStatuses(List<ProcessStatusDto> configurationStatuses) {
    this.configurationStatuses = configurationStatuses;
    return this;
  }

  public ConnectionStatusDto addConfigurationStatusesItem(ProcessStatusDto configurationStatusesItem) {
    if (this.configurationStatuses == null) {
      this.configurationStatuses = new ArrayList<>();
    }
    this.configurationStatuses.add(configurationStatusesItem);
    return this;
  }

  /**
   * Get configurationStatuses
   * @return configurationStatuses
  */
  @Valid 
  @Schema(name = "configurationStatuses", required = false)
  public List<ProcessStatusDto> getConfigurationStatuses() {
    return configurationStatuses;
  }

  public void setConfigurationStatuses(List<ProcessStatusDto> configurationStatuses) {
    this.configurationStatuses = configurationStatuses;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ConnectionStatusDto connectionStatus = (ConnectionStatusDto) o;
    return Objects.equals(this.connectionId, connectionStatus.connectionId) &&
        Objects.equals(this.name, connectionStatus.name) &&
        Objects.equals(this.host, connectionStatus.host) &&
        Objects.equals(this.status, connectionStatus.status) &&
        Objects.equals(this.processStatuses, connectionStatus.processStatuses) &&
        Objects.equals(this.configurationStatuses, connectionStatus.configurationStatuses);
  }

  @Override
  public int hashCode() {
    return Objects.hash(connectionId, name, host, status, processStatuses, configurationStatuses);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ConnectionStatusDto {\n");
    sb.append("    connectionId: ").append(toIndentedString(connectionId)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    host: ").append(toIndentedString(host)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    processStatuses: ").append(toIndentedString(processStatuses)).append("\n");
    sb.append("    configurationStatuses: ").append(toIndentedString(configurationStatuses)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

