/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.2.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.environments.service.rest.server.generated;

import org.qubership.atp.environments.service.rest.server.dto.generated.BaseSearchRequestDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.ConnectionDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.CreateSystemDtoDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.EnvironmentDtoDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.EnvironmentDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.EnvironmentFullVer1ViewDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.EnvironmentsWithFilterRequestDtoGenerated;
import java.util.List;
import org.qubership.atp.environments.service.rest.server.dto.generated.SystemDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.SystemFullVer1ViewDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.SystemFullVer2ViewDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.SystemNameViewDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.SystemTemporaryDtoDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.SystemVersionResponseDtoGenerated;
import java.util.UUID;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-04T17:33:35.988059281Z[Etc/UTC]")
@Validated
@Tag(name = "EnvironmentController", description = "Environment Controller")
public interface EnvironmentControllerApi {

    /**
     * POST /api/environments/{environmentId}/copy : copy
     *
     * @param environmentId environmentId (required)
     * @param environmentDtoDtoGenerated  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "copy",
        summary = "copy",
        tags = { "environment-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/environments/{environmentId}/copy",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<EnvironmentDtoGenerated> copy(
        @Parameter(name = "environmentId", description = "environmentId", required = true) @PathVariable("environmentId") UUID environmentId,
        @Parameter(name = "EnvironmentDtoDtoGenerated", description = "") @Valid @RequestBody(required = false) EnvironmentDtoDtoGenerated environmentDtoDtoGenerated
    );


    /**
     * POST /api/environments : createEnvironment
     *
     * @param environmentDtoDtoGenerated  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "createEnvironment",
        summary = "createEnvironment",
        tags = { "environment-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/environments",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<EnvironmentDtoGenerated> createEnvironment(
        @Parameter(name = "EnvironmentDtoDtoGenerated", description = "") @Valid @RequestBody(required = false) EnvironmentDtoDtoGenerated environmentDtoDtoGenerated
    );


    /**
     * POST /api/environments/{environmentId} : createSystem
     *
     * @param environmentId environmentId (required)
     * @param createSystemDtoDtoGenerated  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "createSystem",
        summary = "createSystem",
        tags = { "environment-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/environments/{environmentId}",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<SystemDtoGenerated> createSystem(
        @Parameter(name = "environmentId", description = "environmentId", required = true) @PathVariable("environmentId") UUID environmentId,
        @Parameter(name = "CreateSystemDtoDtoGenerated", description = "") @Valid @RequestBody(required = false) CreateSystemDtoDtoGenerated createSystemDtoDtoGenerated
    );


    /**
     * DELETE /api/environments/{environmentId} : delete
     *
     * @param environmentId environmentId (required)
     * @return No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     */
    @Operation(
        operationId = "deleteEnvironment",
        summary = "delete",
        tags = { "environment-controller" },
        responses = {
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/api/environments/{environmentId}"
    )
    ResponseEntity<Void> deleteEnvironment(
        @Parameter(name = "environmentId", description = "environmentId", required = true) @PathVariable("environmentId") UUID environmentId
    );


    /**
     * GET /api/v2/environments/{environmentId}/version : detailedUpdateVersion
     *
     * @param environmentId environmentId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "detailedUpdateVersion",
        summary = "detailedUpdateVersion",
        tags = { "environment-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemVersionResponseDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/v2/environments/{environmentId}/version",
        produces = { "application/json" }
    )
    ResponseEntity<List<SystemVersionResponseDtoGenerated>> detailedUpdateVersion(
        @Parameter(name = "environmentId", description = "environmentId", required = true) @PathVariable("environmentId") UUID environmentId
    );


    /**
     * POST /api/environments/search : findBySearchRequest
     *
     * @param baseSearchRequestDtoGenerated searchRequest (required)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "findBySearchRequest",
        summary = "findBySearchRequest",
        tags = { "environment-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/environments/search",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<EnvironmentDtoGenerated>> findBySearchRequest(
        @Parameter(name = "BaseSearchRequestDtoGenerated", description = "searchRequest", required = true) @Valid @RequestBody BaseSearchRequestDtoGenerated baseSearchRequestDtoGenerated,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/environments : getAll
     *
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAll",
        summary = "getAll",
        tags = { "environment-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentFullVer1ViewDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/environments",
        produces = { "application/json" }
    )
    ResponseEntity<List<EnvironmentFullVer1ViewDtoGenerated>> getAll(
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/environments/{environmentId} : getEnvironment
     *
     * @param environmentId environmentId (required)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getEnvironment",
        summary = "getEnvironment",
        tags = { "environment-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentFullVer1ViewDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/environments/{environmentId}",
        produces = { "application/json" }
    )
    ResponseEntity<EnvironmentFullVer1ViewDtoGenerated> getEnvironment(
        @Parameter(name = "environmentId", description = "environmentId", required = true) @PathVariable("environmentId") UUID environmentId,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/environments/{environmentId}/connections : getEnvironmentConnections
     *
     * @param environmentId environmentId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getEnvironmentConnections",
        summary = "getEnvironmentConnections",
        tags = { "environment-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ConnectionDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/environments/{environmentId}/connections",
        produces = { "application/json" }
    )
    ResponseEntity<List<ConnectionDtoGenerated>> getEnvironmentConnections(
        @Parameter(name = "environmentId", description = "environmentId", required = true) @PathVariable("environmentId") UUID environmentId
    );


    /**
     * GET /api/environments/{environmentId}/name : getName
     *
     * @param environmentId environmentId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getEnvironmentNameById",
        summary = "getName",
        tags = { "environment-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "text/plain", schema = @Schema(implementation = String.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/environments/{environmentId}/name",
        produces = { "text/plain" }
    )
    ResponseEntity<String> getEnvironmentNameById(
        @Parameter(name = "environmentId", description = "environmentId", required = true) @PathVariable("environmentId") UUID environmentId
    );


    /**
     * GET /api/environments/{environmentId}/systems : getSystems
     *
     * @param environmentId environmentId (required)
     * @param systemType system_type (optional)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getEnvironmentSystems",
        summary = "getSystems",
        tags = { "environment-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemFullVer1ViewDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/environments/{environmentId}/systems",
        produces = { "application/json" }
    )
    ResponseEntity<List<SystemFullVer1ViewDtoGenerated>> getEnvironmentSystems(
        @Parameter(name = "environmentId", description = "environmentId", required = true) @PathVariable("environmentId") UUID environmentId,
        @Parameter(name = "system_type", description = "system_type") @Valid @RequestParam(value = "system_type", required = false) String systemType,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/environments/{environmentId}/systems/update-versions : Returns all systems with updated versions under environment
     *
     * @param environmentId Id of the environment. Cannot be empty. (required)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getEnvironmentTsg3",
        summary = "Returns all systems with updated versions under environment",
        tags = { "environment-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentFullVer1ViewDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/environments/{environmentId}/systems/update-versions",
        produces = { "application/json" }
    )
    ResponseEntity<EnvironmentFullVer1ViewDtoGenerated> getEnvironmentTsg3(
        @Parameter(name = "environmentId", description = "Id of the environment. Cannot be empty.", required = true) @PathVariable("environmentId") UUID environmentId,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * POST /api/environments/filter : getEnvironmentsByRequest
     *
     * @param full full (optional)
     * @param page full (optional)
     * @param size full (optional)
     * @param environmentsWithFilterRequestDtoGenerated  (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getEnvironmentsByRequest",
        summary = "getEnvironmentsByRequest",
        tags = { "environment-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentFullVer1ViewDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/environments/filter",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<EnvironmentFullVer1ViewDtoGenerated>> getEnvironmentsByRequest(
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full,
        @Parameter(name = "page", description = "full") @Valid @RequestParam(value = "page", required = false) Long page,
        @Parameter(name = "size", description = "full") @Valid @RequestParam(value = "size", required = false) Long size,
        @Parameter(name = "EnvironmentsWithFilterRequestDtoGenerated", description = "") @Valid @RequestBody(required = false) EnvironmentsWithFilterRequestDtoGenerated environmentsWithFilterRequestDtoGenerated
    );


    /**
     * GET /api/public/v1/environments/{environmentIds}/systems/htmlVersions : getPublicHtmlVersion
     *
     * @param environmentIds environmentIds (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getPublicHtmlVersion",
        summary = "getPublicHtmlVersion",
        tags = { "environment-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "text/plain", schema = @Schema(implementation = String.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/public/v1/environments/{environmentIds}/systems/htmlVersions",
        produces = { "text/plain" }
    )
    ResponseEntity<String> getPublicHtmlVersion(
        @Parameter(name = "environmentIds", description = "environmentIds", required = true) @PathVariable("environmentIds") List<UUID> environmentIds
    );


    /**
     * GET /api/v2/environments/{environmentId}/systems : getSystemV2
     *
     * @param environmentId environmentId (required)
     * @param systemType system_type (optional)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getSystemV2",
        summary = "getSystemV2",
        tags = { "environment-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemFullVer2ViewDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/v2/environments/{environmentId}/systems",
        produces = { "application/json" }
    )
    ResponseEntity<List<SystemFullVer2ViewDtoGenerated>> getSystemV2(
        @Parameter(name = "environmentId", description = "environmentId", required = true) @PathVariable("environmentId") UUID environmentId,
        @Parameter(name = "system_type", description = "system_type") @Valid @RequestParam(value = "system_type", required = false) String systemType,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/environments/{environmentId}/systems/short : getSystemsShort
     *
     * @param environmentId environmentId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getSystemsShort",
        summary = "getSystemsShort",
        tags = { "environment-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemNameViewDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/environments/{environmentId}/systems/short",
        produces = { "application/json" }
    )
    ResponseEntity<List<SystemNameViewDtoGenerated>> getSystemsShort(
        @Parameter(name = "environmentId", description = "environmentId", required = true) @PathVariable("environmentId") UUID environmentId
    );


    /**
     * POST /api/environments/{environmentId}/temporary : temporary
     *
     * @param environmentId environmentId (required)
     * @param full full (optional)
     * @param systemTemporaryDtoDtoGenerated  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "temporary",
        summary = "temporary",
        tags = { "environment-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentFullVer1ViewDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/environments/{environmentId}/temporary",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<EnvironmentFullVer1ViewDtoGenerated> temporary(
        @Parameter(name = "environmentId", description = "environmentId", required = true) @PathVariable("environmentId") UUID environmentId,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full,
        @Parameter(name = "SystemTemporaryDtoDtoGenerated", description = "") @Valid @RequestBody(required = false) List<SystemTemporaryDtoDtoGenerated> systemTemporaryDtoDtoGenerated
    );


    /**
     * PUT /api/environments : update
     *
     * @param environmentDtoDtoGenerated  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateEnvironment",
        summary = "update",
        tags = { "environment-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/api/environments",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> updateEnvironment(
        @Parameter(name = "EnvironmentDtoDtoGenerated", description = "") @Valid @RequestBody(required = false) EnvironmentDtoDtoGenerated environmentDtoDtoGenerated
    );


    /**
     * GET /api/environments/{environmentId}/version : updateVersion
     *
     * @param environmentId environmentId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateVersion",
        summary = "updateVersion",
        tags = { "environment-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemDtoGenerated.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/environments/{environmentId}/version",
        produces = { "application/json" }
    )
    ResponseEntity<List<SystemDtoGenerated>> updateVersion(
        @Parameter(name = "environmentId", description = "environmentId", required = true) @PathVariable("environmentId") UUID environmentId
    );

}
